/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.conversations;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.vonage.client.conversations.AudioRecordEventBody;
import com.vonage.client.conversations.Event;
import com.vonage.client.conversations.EventType;
import com.vonage.client.conversations.EventWithBody;
import com.vonage.client.voice.TextToSpeechLanguage;

public final class AudioRecordEvent
extends EventWithBody<AudioRecordEventBody> {
    AudioRecordEvent() {
    }

    private AudioRecordEvent(Builder builder) {
        super(builder);
        this.body = new AudioRecordEventBody(builder);
    }

    @JsonIgnore
    public TextToSpeechLanguage getLanguage() {
        return ((AudioRecordEventBody)this.body).transcription != null ? ((AudioRecordEventBody)this.body).transcription.language : null;
    }

    @JsonIgnore
    public Boolean getSentimentAnalysis() {
        return ((AudioRecordEventBody)this.body).transcription != null ? ((AudioRecordEventBody)this.body).transcription.sentimentAnalysis : null;
    }

    @JsonIgnore
    public String getFormat() {
        return ((AudioRecordEventBody)this.body).format;
    }

    @JsonIgnore
    public Integer getValidity() {
        return ((AudioRecordEventBody)this.body).validity;
    }

    @JsonIgnore
    public Integer getChannels() {
        return ((AudioRecordEventBody)this.body).channels;
    }

    @JsonIgnore
    public Boolean getStreamed() {
        return ((AudioRecordEventBody)this.body).streamed;
    }

    @JsonIgnore
    public Boolean getSplit() {
        return ((AudioRecordEventBody)this.body).split;
    }

    @JsonIgnore
    public Boolean getMultitrack() {
        return ((AudioRecordEventBody)this.body).multitrack;
    }

    @JsonIgnore
    public Boolean getDetectSpeech() {
        return ((AudioRecordEventBody)this.body).detectSpeech;
    }

    @JsonIgnore
    public Boolean getBeepStart() {
        return ((AudioRecordEventBody)this.body).beepStart;
    }

    @JsonIgnore
    public Boolean getBeepStop() {
        return ((AudioRecordEventBody)this.body).beepStop;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends Event.Builder<AudioRecordEvent, Builder> {
        String format;
        Integer validity;
        Integer channels;
        Boolean streamed;
        Boolean split;
        Boolean multitrack;
        Boolean detectSpeech;
        Boolean beepStart;
        Boolean beepStop;
        Boolean sentimentAnalysis;
        TextToSpeechLanguage language;

        Builder() {
            super(EventType.AUDIO_RECORD);
        }

        public Builder format(String format) {
            this.format = format;
            return this;
        }

        public Builder validity(int validity) {
            this.validity = validity;
            return this;
        }

        public Builder channels(int channels) {
            this.channels = channels;
            return this;
        }

        public Builder streamed(boolean streamed) {
            this.streamed = streamed;
            return this;
        }

        public Builder split(boolean split) {
            this.split = split;
            return this;
        }

        public Builder multitrack(boolean multitrack) {
            this.multitrack = multitrack;
            return this;
        }

        public Builder detectSpeech(boolean detectSpeech) {
            this.detectSpeech = detectSpeech;
            return this;
        }

        public Builder beepStart(boolean beepStart) {
            this.beepStart = beepStart;
            return this;
        }

        public Builder beepStop(boolean beepStop) {
            this.beepStop = beepStop;
            return this;
        }

        public Builder sentimentAnalysis(boolean sentimentAnalysis) {
            this.sentimentAnalysis = sentimentAnalysis;
            return this;
        }

        public Builder language(TextToSpeechLanguage language) {
            this.language = language;
            return this;
        }

        @Override
        public AudioRecordEvent build() {
            return new AudioRecordEvent(this);
        }
    }
}

