/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.conversations;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.JsonableBaseObject;
import java.util.Map;

public class ConversationProperties
extends JsonableBaseObject {
    private Integer ttl;
    private String type;
    private String customSortKey;
    private Map<String, Object> customData;

    ConversationProperties() {
    }

    ConversationProperties(Builder builder) {
        this.ttl = builder.ttl;
        this.type = builder.type;
        if (this.type != null && (this.type.length() > 200 || this.type.trim().isEmpty())) {
            throw new IllegalArgumentException("Type must be between 1 and 200 characters.");
        }
        this.customSortKey = builder.customSortKey;
        if (this.customSortKey != null && (this.customSortKey.length() > 200 || this.customSortKey.trim().isEmpty())) {
            throw new IllegalArgumentException("Custom sort key must be between 1 and 200 characters.");
        }
        this.customData = builder.customData;
    }

    @JsonProperty(value="ttl")
    public Integer getTtl() {
        return this.ttl;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="custom_sort_key")
    public String getCustomSortKey() {
        return this.customSortKey;
    }

    @JsonProperty(value="custom_data")
    public Map<String, Object> getCustomData() {
        return this.customData;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Integer ttl;
        private String type;
        private String customSortKey;
        private Map<String, Object> customData;

        Builder() {
        }

        public Builder ttl(Integer ttl) {
            this.ttl = ttl;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder customSortKey(String customSortKey) {
            this.customSortKey = customSortKey;
            return this;
        }

        public Builder customData(Map<String, Object> customData) {
            this.customData = customData;
            return this;
        }

        public ConversationProperties build() {
            return new ConversationProperties(this);
        }
    }
}

