/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.conversations;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.JsonableBaseObject;
import com.vonage.client.conversations.MediaAudioSettings;

public final class MemberMedia
extends JsonableBaseObject {
    private Boolean audio;
    private MediaAudioSettings audioSettings;

    MemberMedia(Builder builder) {
        this.audio = builder.audio;
        this.audioSettings = builder.audioSettings;
    }

    MemberMedia() {
    }

    @JsonProperty(value="audio")
    public Boolean getAudio() {
        return this.audio;
    }

    @JsonProperty(value="audio_settings")
    public MediaAudioSettings getAudioSettings() {
        return this.audioSettings;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean audio;
        private MediaAudioSettings audioSettings;

        private Builder() {
        }

        private MediaAudioSettings initAudioSettings() {
            if (this.audioSettings == null) {
                this.audioSettings = new MediaAudioSettings();
            }
            return this.audioSettings;
        }

        public Builder audio(boolean audio) {
            this.audio = audio;
            return this;
        }

        public Builder audioEnabled(boolean enabled) {
            this.initAudioSettings().enabled = enabled;
            return this;
        }

        public Builder earmuffed(boolean earmuffed) {
            this.initAudioSettings().earmuffed = earmuffed;
            return this;
        }

        public Builder muted(boolean muted) {
            this.initAudioSettings().muted = muted;
            return this;
        }

        public MemberMedia build() {
            return new MemberMedia(this);
        }
    }
}

