/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.conversations;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.vonage.client.common.MessageType;
import com.vonage.client.conversations.Event;
import com.vonage.client.conversations.EventType;
import com.vonage.client.conversations.EventWithBody;
import com.vonage.client.conversations.Location;
import com.vonage.client.conversations.MessageEventBody;
import java.net.URI;

public final class MessageEvent
extends EventWithBody<MessageEventBody> {
    MessageEvent() {
    }

    MessageEvent(Builder builder) {
        super(builder);
        this.body = new MessageEventBody(builder);
    }

    @JsonIgnore
    public MessageType getMessageType() {
        return ((MessageEventBody)this.body).messageType;
    }

    @JsonIgnore
    public String getText() {
        return ((MessageEventBody)this.body).text;
    }

    @JsonIgnore
    public URI getUrl() {
        switch (this.getMessageType()) {
            default: {
                return null;
            }
            case FILE: {
                return ((MessageEventBody)this.body).file.url;
            }
            case IMAGE: {
                return ((MessageEventBody)this.body).image.url;
            }
            case AUDIO: {
                return ((MessageEventBody)this.body).audio.url;
            }
            case VIDEO: {
                return ((MessageEventBody)this.body).video.url;
            }
            case VCARD: 
        }
        return ((MessageEventBody)this.body).vcard.url;
    }

    @JsonIgnore
    public Location getLocation() {
        return ((MessageEventBody)this.body).location;
    }

    public static Builder builder(MessageType messageType) {
        return new Builder(messageType);
    }

    public static final class Builder
    extends Event.Builder<MessageEvent, Builder> {
        final MessageType messageType;
        String text;
        URI url;
        Location location;

        Builder(MessageType messageType) {
            super(EventType.MESSAGE);
            this.messageType = messageType;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder url(String url) {
            this.url = URI.create(url);
            return this;
        }

        public Builder location(Location location) {
            this.location = location;
            return this;
        }

        @Override
        public MessageEvent build() {
            return new MessageEvent(this);
        }
    }
}

