/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.insight;

import com.vonage.client.DynamicEndpoint;
import com.vonage.client.HttpWrapper;
import com.vonage.client.RestEndpoint;
import com.vonage.client.VonageClientException;
import com.vonage.client.VonageResponseParseException;
import com.vonage.client.auth.ApiKeyQueryParamsAuthMethod;
import com.vonage.client.auth.SignatureAuthMethod;
import com.vonage.client.common.HttpMethod;
import com.vonage.client.insight.AdvancedInsightRequest;
import com.vonage.client.insight.AdvancedInsightResponse;
import com.vonage.client.insight.BasicInsightRequest;
import com.vonage.client.insight.BasicInsightResponse;
import com.vonage.client.insight.StandardInsightRequest;
import com.vonage.client.insight.StandardInsightResponse;
import java.util.function.Function;

public class InsightClient {
    final RestEndpoint<BasicInsightRequest, BasicInsightResponse> basic;
    final RestEndpoint<StandardInsightRequest, StandardInsightResponse> standard;
    final RestEndpoint<AdvancedInsightRequest, AdvancedInsightResponse> advanced;

    public InsightClient(final HttpWrapper wrapper) {
        final class Endpoint<T, R>
        extends DynamicEndpoint<T, R> {
            Endpoint(Function<T, String> pathGetter, R ... type) {
                super(DynamicEndpoint.builder(type).wrapper(var4_4).requestMethod(HttpMethod.POST).authMethod(SignatureAuthMethod.class, ApiKeyQueryParamsAuthMethod.class).pathGetter((de, req) -> {
                    String base = de.getHttpWrapper().getHttpConfig().getApiBaseUri();
                    return base + "/ni/" + (String)pathGetter.apply(req) + "/json";
                }));
            }
        }
        this.basic = new Endpoint(req -> "basic", (Object[])new BasicInsightResponse[0]);
        this.standard = new Endpoint(req -> "standard", (Object[])new StandardInsightResponse[0]);
        this.advanced = new Endpoint(req -> "advanced" + (req.isAsync() ? "/async" : ""), (Object[])new AdvancedInsightResponse[0]);
    }

    public BasicInsightResponse getBasicNumberInsight(String number) throws VonageResponseParseException, VonageClientException {
        return this.getBasicNumberInsight(BasicInsightRequest.withNumber(number));
    }

    public BasicInsightResponse getBasicNumberInsight(String number, String country) throws VonageResponseParseException, VonageClientException {
        return this.getBasicNumberInsight(BasicInsightRequest.withNumberAndCountry(number, country));
    }

    public BasicInsightResponse getBasicNumberInsight(BasicInsightRequest basicInsightRequest) throws VonageResponseParseException, VonageClientException {
        return this.basic.execute(basicInsightRequest);
    }

    public StandardInsightResponse getStandardNumberInsight(String number) throws VonageResponseParseException, VonageClientException {
        return this.getStandardNumberInsight(StandardInsightRequest.withNumber(number));
    }

    public StandardInsightResponse getStandardNumberInsight(String number, String country) throws VonageResponseParseException, VonageClientException {
        return this.getStandardNumberInsight(StandardInsightRequest.withNumberAndCountry(number, country));
    }

    public StandardInsightResponse getStandardNumberInsight(StandardInsightRequest standardInsightRequest) throws VonageResponseParseException, VonageClientException {
        return this.standard.execute(standardInsightRequest);
    }

    public AdvancedInsightResponse getAdvancedNumberInsight(String number) throws VonageResponseParseException, VonageClientException {
        return this.getAdvancedNumberInsight(AdvancedInsightRequest.withNumber(number));
    }

    public AdvancedInsightResponse getAdvancedNumberInsight(String number, String country) throws VonageResponseParseException, VonageClientException {
        return this.getAdvancedNumberInsight(AdvancedInsightRequest.withNumberAndCountry(number, country));
    }

    public AdvancedInsightResponse getAdvancedNumberInsight(AdvancedInsightRequest advancedInsightRequest) throws VonageResponseParseException, VonageClientException {
        return this.advanced.execute(advancedInsightRequest);
    }
}

