/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.meetings;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.Jsonable;
import com.vonage.client.JsonableBaseObject;
import com.vonage.client.meetings.AvailableFeatures;
import com.vonage.client.meetings.CallbackUrls;
import com.vonage.client.meetings.InitialJoinOptions;
import com.vonage.client.meetings.JoinApprovalLevel;
import com.vonage.client.meetings.RecordingOptions;
import com.vonage.client.meetings.RoomLinks;
import com.vonage.client.meetings.RoomType;
import com.vonage.client.meetings.UISettings;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.UUID;

public class MeetingRoom
extends JsonableBaseObject {
    private Instant createdAt;
    private Instant expiresAt;
    private UUID id;
    private UUID themeId;
    private String displayName;
    private String metadata;
    private String meetingCode;
    private Boolean isAvailable;
    private Boolean expireAfterUse;
    private RoomType type;
    private JoinApprovalLevel joinApprovalLevel;
    private RecordingOptions recordingOptions;
    private InitialJoinOptions initialJoinOptions;
    private UISettings uiSettings;
    private CallbackUrls callbackUrls;
    private AvailableFeatures availableFeatures;
    private RoomLinks links;

    protected MeetingRoom() {
    }

    MeetingRoom(Builder builder) {
        this.displayName = builder.displayName;
        if (this.displayName == null || this.displayName.trim().isEmpty()) {
            throw new IllegalArgumentException("Display name is required and cannot be empty.");
        }
        this.expiresAt = builder.expiresAt;
        this.type = builder.type;
        MeetingRoom.validateExpiresAtAndRoomType(this.expiresAt, this.type);
        this.expireAfterUse = builder.expireAfterUse;
        if (this.expireAfterUse != null && this.type == RoomType.INSTANT) {
            throw new IllegalStateException("expireAfterUse is not applicable to " + (Object)((Object)this.type) + " rooms.");
        }
        this.metadata = builder.metadata;
        this.isAvailable = builder.isAvailable;
        this.recordingOptions = builder.recordingOptions;
        this.initialJoinOptions = builder.initialJoinOptions;
        this.callbackUrls = builder.callbackUrls;
        this.availableFeatures = builder.availableFeatures;
        this.themeId = builder.themeId;
        this.joinApprovalLevel = builder.joinApprovalLevel;
        this.uiSettings = builder.uiSettings;
    }

    static void validateExpiresAtAndRoomType(Instant expiresAt, RoomType type) {
        if (type == RoomType.INSTANT && expiresAt != null) {
            throw new IllegalStateException("Expiration time should not be specified for " + (Object)((Object)type) + " rooms.");
        }
        if (type == RoomType.LONG_TERM && expiresAt == null) {
            throw new IllegalStateException("Expiration time must be specified for " + (Object)((Object)type) + " rooms.");
        }
        if (expiresAt != null && expiresAt.isBefore(Instant.now().plusSeconds(600L))) {
            throw new IllegalArgumentException("Expiration time should be more than 10 minutes from now.");
        }
    }

    @JsonProperty(value="display_name")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="metadata")
    public String getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="meeting_code")
    public String getMeetingCode() {
        return this.meetingCode;
    }

    @JsonProperty(value="type")
    public RoomType getType() {
        return this.type;
    }

    @JsonProperty(value="is_available")
    public Boolean getIsAvailable() {
        return this.isAvailable;
    }

    @JsonProperty(value="expire_after_use")
    public Boolean getExpireAfterUse() {
        return this.expireAfterUse;
    }

    @JsonProperty(value="recording_options")
    public RecordingOptions getRecordingOptions() {
        return this.recordingOptions;
    }

    @JsonProperty(value="initial_join_options")
    public InitialJoinOptions getInitialJoinOptions() {
        return this.initialJoinOptions;
    }

    @JsonProperty(value="ui_settings")
    public UISettings getUiSettings() {
        return this.uiSettings;
    }

    @JsonProperty(value="callback_urls")
    public CallbackUrls getCallbackUrls() {
        return this.callbackUrls;
    }

    @JsonProperty(value="available_features")
    public AvailableFeatures getAvailableFeatures() {
        return this.availableFeatures;
    }

    @JsonProperty(value="theme_id")
    public UUID getThemeId() {
        return this.themeId;
    }

    @JsonProperty(value="join_approval_level")
    public JoinApprovalLevel getJoinApprovalLevel() {
        return this.joinApprovalLevel;
    }

    @JsonProperty(value="created_at")
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="expires_at")
    public Instant getExpiresAt() {
        return this.expiresAt;
    }

    @JsonProperty(value="id")
    public UUID getId() {
        return this.id;
    }

    @JsonProperty(value="_links")
    public RoomLinks getLinks() {
        return this.links;
    }

    public static MeetingRoom fromJson(String json) {
        return (MeetingRoom)Jsonable.fromJson((String)json, (Jsonable[])new MeetingRoom[0]);
    }

    public static Builder builder(String displayName) {
        return new Builder(displayName);
    }

    public static class Builder {
        private final String displayName;
        private UUID themeId;
        private String metadata;
        private Instant expiresAt;
        private Boolean isAvailable;
        private Boolean expireAfterUse;
        private RoomType type;
        private JoinApprovalLevel joinApprovalLevel;
        private RecordingOptions recordingOptions;
        private InitialJoinOptions initialJoinOptions;
        private UISettings uiSettings;
        private CallbackUrls callbackUrls;
        private AvailableFeatures availableFeatures;

        Builder(String displayName) {
            this.displayName = displayName;
        }

        public Builder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder type(RoomType type) {
            this.type = type;
            return this;
        }

        public Builder isAvailable(boolean isAvailable) {
            this.isAvailable = isAvailable;
            return this;
        }

        public Builder expireAfterUse(boolean expireAfterUse) {
            this.expireAfterUse = expireAfterUse;
            return this;
        }

        public Builder recordingOptions(RecordingOptions recordingOptions) {
            this.recordingOptions = recordingOptions;
            return this;
        }

        public Builder initialJoinOptions(InitialJoinOptions initialJoinOptions) {
            this.initialJoinOptions = initialJoinOptions;
            return this;
        }

        public Builder uiSettings(UISettings uiSettings) {
            this.uiSettings = uiSettings;
            return this;
        }

        public Builder callbackUrls(CallbackUrls callbackUrls) {
            this.callbackUrls = callbackUrls;
            return this;
        }

        public Builder availableFeatures(AvailableFeatures availableFeatures) {
            this.availableFeatures = availableFeatures;
            return this;
        }

        public Builder themeId(UUID themeId) {
            this.themeId = themeId;
            return this;
        }

        public Builder joinApprovalLevel(JoinApprovalLevel joinApprovalLevel) {
            this.joinApprovalLevel = joinApprovalLevel;
            return this;
        }

        public Builder expiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt.truncatedTo(ChronoUnit.MILLIS);
            return this;
        }

        public MeetingRoom build() {
            return new MeetingRoom(this);
        }
    }
}

