/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.meetings;

import com.vonage.client.DynamicEndpoint;
import com.vonage.client.HttpWrapper;
import com.vonage.client.RestEndpoint;
import com.vonage.client.VonageClientException;
import com.vonage.client.VonageUnexpectedException;
import com.vonage.client.auth.JWTAuthMethod;
import com.vonage.client.common.HalPageResponse;
import com.vonage.client.common.HttpMethod;
import com.vonage.client.meetings.Application;
import com.vonage.client.meetings.DeleteThemeRequest;
import com.vonage.client.meetings.DialInNumber;
import com.vonage.client.meetings.FinalizeLogosRequest;
import com.vonage.client.meetings.GetLogoUploadUrlsResponse;
import com.vonage.client.meetings.ListDialNumbersResponse;
import com.vonage.client.meetings.ListRecordingsResponse;
import com.vonage.client.meetings.ListRoomsRequest;
import com.vonage.client.meetings.ListRoomsResponse;
import com.vonage.client.meetings.ListThemesResponse;
import com.vonage.client.meetings.LogoType;
import com.vonage.client.meetings.LogoUploadsUrlResponse;
import com.vonage.client.meetings.MeetingRoom;
import com.vonage.client.meetings.MeetingsResponseException;
import com.vonage.client.meetings.Recording;
import com.vonage.client.meetings.Theme;
import com.vonage.client.meetings.UpdateApplicationRequest;
import com.vonage.client.meetings.UpdateRoomRequest;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.mime.MultipartEntityBuilder;

@Deprecated
public class MeetingsClient {
    HttpClient httpClient;
    final RestEndpoint<ListRoomsRequest, ListRoomsResponse> listRooms;
    final RestEndpoint<ListRoomsRequest, ListRoomsResponse> searchThemeRooms;
    final RestEndpoint<UUID, MeetingRoom> getRoom;
    final RestEndpoint<MeetingRoom, MeetingRoom> createRoom;
    final RestEndpoint<UpdateRoomRequest, MeetingRoom> updateRoom;
    final RestEndpoint<Void, ListThemesResponse> listThemes;
    final RestEndpoint<UUID, Theme> getTheme;
    final RestEndpoint<Theme, Theme> createTheme;
    final RestEndpoint<Theme, Theme> updateTheme;
    final RestEndpoint<DeleteThemeRequest, Void> deleteTheme;
    final RestEndpoint<String, ListRecordingsResponse> listRecordings;
    final RestEndpoint<UUID, Recording> getRecording;
    final RestEndpoint<UUID, Void> deleteRecording;
    final RestEndpoint<Void, ListDialNumbersResponse> listDialNumbers;
    final RestEndpoint<UpdateApplicationRequest, Application> updateApplication;
    final RestEndpoint<FinalizeLogosRequest, Void> finalizeLogos;
    final RestEndpoint<Void, GetLogoUploadUrlsResponse> getLogoUploadUrls;

    public MeetingsClient(final HttpWrapper wrapper) {
        this.httpClient = wrapper.getHttpClient();
        class Endpoint<T, R>
        extends DynamicEndpoint<T, R> {
            Endpoint(Function<T, String> pathGetter, HttpMethod method, R ... type) {
                super(DynamicEndpoint.builder(type).authMethod(JWTAuthMethod.class, new Class[0]).requestMethod(method).responseExceptionType(MeetingsResponseException.class).wrapper(var5_5).pathGetter((de, req) -> {
                    String base = de.getHttpWrapper().getHttpConfig().getApiEuBaseUri();
                    return base + "/v1/meetings/" + (String)pathGetter.apply(req);
                }));
            }
        }
        this.listRooms = new Endpoint(req -> "rooms", HttpMethod.GET, (Object[])new ListRoomsResponse[0]);
        this.getRoom = new Endpoint(roomId -> "rooms/" + roomId, HttpMethod.GET, (Object[])new MeetingRoom[0]);
        this.createRoom = new Endpoint(req -> "rooms", HttpMethod.POST, (Object[])new MeetingRoom[0]);
        this.updateRoom = new Endpoint(req -> "rooms/" + req.roomId, HttpMethod.PATCH, (Object[])new MeetingRoom[0]);
        this.searchThemeRooms = new Endpoint(req -> "themes/" + req.themeId + "/rooms", HttpMethod.GET, (Object[])new ListRoomsResponse[0]);
        this.listThemes = new Endpoint(req -> "themes", HttpMethod.GET, (Object[])new ListThemesResponse[0]);
        this.getTheme = new Endpoint(themeId -> "themes/" + themeId, HttpMethod.GET, (Object[])new Theme[0]);
        this.createTheme = new Endpoint(req -> "themes", HttpMethod.POST, (Object[])new Theme[0]);
        this.updateTheme = new Endpoint(theme -> "themes/" + theme.getThemeId(), HttpMethod.PATCH, (Object[])new Theme[0]);
        this.deleteTheme = new Endpoint(req -> "themes/" + req.themeId, HttpMethod.DELETE, (Object[])new Void[0]);
        this.listRecordings = new Endpoint(sid -> "sessions/" + sid + "/recordings", HttpMethod.GET, (Object[])new ListRecordingsResponse[0]);
        this.getRecording = new Endpoint(rid -> "recordings/" + rid, HttpMethod.GET, (Object[])new Recording[0]);
        this.deleteRecording = new Endpoint(rid -> "recordings/" + rid, HttpMethod.DELETE, (Object[])new Void[0]);
        this.listDialNumbers = new Endpoint(req -> "dial-in-numbers", HttpMethod.GET, (Object[])new ListDialNumbersResponse[0]);
        this.updateApplication = new Endpoint(req -> "applications", HttpMethod.PATCH, (Object[])new Application[0]);
        this.finalizeLogos = new Endpoint(req -> "themes/" + req.themeId + "/finalizeLogos", HttpMethod.PUT, (Object[])new Void[0]);
        this.getLogoUploadUrls = new Endpoint(req -> "themes/logos-upload-urls", HttpMethod.GET, (Object[])new GetLogoUploadUrlsResponse[0]);
    }

    static UUID validateThemeId(UUID themeId) {
        return Objects.requireNonNull(themeId, "Theme ID is required.");
    }

    static UUID validateRoomId(UUID roomId) {
        return Objects.requireNonNull(roomId, "Room ID is required.");
    }

    static UUID validateRecordingId(UUID recordingId) {
        return Objects.requireNonNull(recordingId, "Recording ID is required.");
    }

    static String validateSessionId(String sessionId) {
        if (sessionId == null || sessionId.trim().isEmpty()) {
            throw new IllegalArgumentException("Session ID cannot be null or empty.");
        }
        return sessionId;
    }

    private int parseNextFromHalResponse(HalPageResponse response) {
        URI nextUrl = response.getLinks().getNextUrl();
        return URLEncodedUtils.parse((URI)nextUrl, (Charset)Charset.defaultCharset()).stream().filter(nvp -> "start_id".equals(nvp.getName())).findFirst().map(nvp -> Integer.parseInt(nvp.getValue())).orElseThrow(() -> new VonageClientException("Couldn't navigate to next page: " + nextUrl));
    }

    private List<MeetingRoom> getAllRoomsFromResponseRecursively(RestEndpoint<ListRoomsRequest, ListRoomsResponse> endpoint, ListRoomsRequest initialRequest) {
        int initialPageSize = initialRequest.pageSize != null ? initialRequest.pageSize : 1000;
        ListRoomsRequest request = new ListRoomsRequest(initialRequest.startId, initialRequest.endId, initialPageSize, initialRequest.themeId);
        ListRoomsResponse response = endpoint.execute(request);
        if (response.getTotalItems() <= response.getPageSize()) {
            return response.getMeetingRooms();
        }
        ArrayList<MeetingRoom> rooms = new ArrayList<MeetingRoom>(response.getMeetingRooms());
        do {
            request = new ListRoomsRequest(this.parseNextFromHalResponse(response), null, initialPageSize, request.themeId);
            response = endpoint.execute(request);
            rooms.addAll(response.getMeetingRooms());
        } while (response.getPageSize() >= initialPageSize);
        return rooms;
    }

    public List<MeetingRoom> listRooms() {
        return this.getAllRoomsFromResponseRecursively(this.listRooms, new ListRoomsRequest(null, null, null, null));
    }

    public MeetingRoom getRoom(UUID roomId) {
        return this.getRoom.execute(MeetingsClient.validateRoomId(roomId));
    }

    public MeetingRoom createRoom(MeetingRoom room) {
        return this.createRoom.execute(Objects.requireNonNull(room, "Meeting room is required."));
    }

    public MeetingRoom updateRoom(UUID roomId, UpdateRoomRequest roomUpdate) {
        Objects.requireNonNull(roomUpdate, "Room update request properties is required.");
        roomUpdate.roomId = MeetingsClient.validateRoomId(roomId);
        return this.updateRoom.execute(roomUpdate);
    }

    public List<MeetingRoom> searchRoomsByTheme(UUID themeId) {
        return this.getAllRoomsFromResponseRecursively(this.searchThemeRooms, new ListRoomsRequest(null, null, null, MeetingsClient.validateThemeId(themeId)));
    }

    public List<Theme> listThemes() {
        return this.listThemes.execute(null);
    }

    public Theme getTheme(UUID themeId) {
        return this.getTheme.execute(MeetingsClient.validateThemeId(themeId));
    }

    public Theme createTheme(Theme theme) {
        Objects.requireNonNull(theme, "Theme creation properties are required.");
        Objects.requireNonNull(theme.getBrandText(), "Brand text is required.");
        Objects.requireNonNull(theme.getMainColor(), "Main color is required.");
        return this.createTheme.execute(theme);
    }

    public Theme updateTheme(UUID themeId, Theme theme) {
        Objects.requireNonNull(theme, "Theme update properties are required.");
        theme.setThemeIdAndFlagUpdate(MeetingsClient.validateThemeId(themeId));
        return this.updateTheme.execute(theme);
    }

    public void deleteTheme(UUID themeId, boolean force) {
        this.deleteTheme.execute(new DeleteThemeRequest(MeetingsClient.validateThemeId(themeId), force));
    }

    public List<Recording> listRecordings(String sessionId) {
        ListRecordingsResponse response = this.listRecordings.execute(MeetingsClient.validateSessionId(sessionId));
        List<Recording> recordings = response.getRecordings();
        return recordings != null ? recordings : Collections.emptyList();
    }

    public Recording getRecording(UUID recordingId) {
        return this.getRecording.execute(MeetingsClient.validateRecordingId(recordingId));
    }

    public void deleteRecording(UUID recordingId) {
        this.deleteRecording.execute(MeetingsClient.validateRecordingId(recordingId));
    }

    public List<DialInNumber> listDialNumbers() {
        return this.listDialNumbers.execute(null);
    }

    public Application updateApplication(UpdateApplicationRequest updateRequest) {
        return this.updateApplication.execute(Objects.requireNonNull(updateRequest, "Application update properties are required."));
    }

    void finalizeLogos(UUID themeId, List<String> keys) {
        if (keys == null || keys.isEmpty()) {
            throw new IllegalArgumentException("Logo keys are required.");
        }
        this.finalizeLogos.execute(new FinalizeLogosRequest(MeetingsClient.validateThemeId(themeId), keys));
    }

    List<LogoUploadsUrlResponse> listLogoUploadUrls() {
        return this.getLogoUploadUrls.execute(null);
    }

    LogoUploadsUrlResponse getUploadDetailsForLogoType(LogoType logoType) {
        return this.listLogoUploadUrls().stream().filter(r -> logoType.equals((Object)r.getFields().getLogoType())).findFirst().orElseThrow(() -> new IllegalArgumentException("Logo type " + (Object)((Object)logoType) + " is unavailable."));
    }

    void uploadLogo(Path logoFile, LogoUploadsUrlResponse details) {
        try {
            LogoUploadsUrlResponse.Fields fields = details.getFields();
            HttpEntity entity = MultipartEntityBuilder.create().addTextBody("Content-Type", fields.getContentType()).addTextBody("key", fields.getKey()).addTextBody("logoType", fields.getLogoType().toString()).addTextBody("bucket", fields.getBucket()).addTextBody("X-Amz-Algorithm", fields.getAmzAlgorithm()).addTextBody("X-Amz-Credential", fields.getAmzCredential()).addTextBody("X-Amz-Date", fields.getAmzDate()).addTextBody("X-Amz-Security-Token", fields.getAmzSecurityToken()).addTextBody("Policy", fields.getPolicy()).addTextBody("X-Amz-Signature", fields.getAmzSignature()).addBinaryBody("file", logoFile.toFile()).build();
            HttpResponse response = this.httpClient.execute(RequestBuilder.post((URI)details.getUrl()).setEntity(entity).build());
            StatusLine status = response.getStatusLine();
            int statusCode = status.getStatusCode();
            if (statusCode != 204) {
                MeetingsResponseException mrx = new MeetingsResponseException("Logo upload failed (" + statusCode + "): " + status.getReasonPhrase());
                mrx.setStatusCode(statusCode);
                throw mrx;
            }
        }
        catch (IOException ex) {
            throw new VonageUnexpectedException(ex);
        }
    }

    public void updateThemeLogo(UUID themeId, LogoType logoType, Path pngFile) {
        LogoUploadsUrlResponse target = this.getUploadDetailsForLogoType(Objects.requireNonNull(logoType, "Logo type cannot be null."));
        this.uploadLogo(Objects.requireNonNull(pngFile, "Image file cannot be null."), target);
        this.finalizeLogos(themeId, Collections.singletonList(target.getFields().getKey()));
    }
}

