/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.messages;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.vonage.client.Jsonable;
import com.vonage.client.JsonableBaseObject;
import com.vonage.client.messages.Channel;
import com.vonage.client.messages.whatsapp.ConversationType;
import java.net.URI;
import java.time.Instant;
import java.util.Currency;
import java.util.Map;
import java.util.UUID;

public class MessageStatus
extends JsonableBaseObject {
    @JsonAnySetter
    protected Map<String, Object> unknownProperties;
    @JsonProperty(value="timestamp")
    protected Instant timestamp;
    @JsonProperty(value="message_uuid")
    protected UUID messageUuid;
    @JsonProperty(value="to")
    protected String to;
    @JsonProperty(value="from")
    protected String from;
    @JsonProperty(value="status")
    protected Status status;
    @JsonProperty(value="channel")
    protected Channel channel;
    @JsonProperty(value="client_ref")
    protected String clientRef;
    @JsonProperty(value="error")
    protected Error error;
    @JsonProperty(value="usage")
    protected Usage usage;
    @JsonProperty(value="destination")
    private Destination destination;
    @JsonProperty(value="sms")
    private Sms sms;
    @JsonProperty(value="whatsapp")
    private Whatsapp whatsapp;

    protected MessageStatus() {
    }

    public UUID getMessageUuid() {
        return this.messageUuid;
    }

    public String getTo() {
        return this.to;
    }

    public String getFrom() {
        return this.from;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public Status getStatus() {
        return this.status;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public String getClientRef() {
        return this.clientRef;
    }

    public Error getError() {
        return this.error;
    }

    public Usage getUsage() {
        return this.usage;
    }

    @JsonIgnore
    public String getDestinationNetworkCode() {
        return this.destination != null ? this.destination.networkCode : null;
    }

    @JsonIgnore
    public Integer getSmsTotalCount() {
        return this.sms != null ? this.sms.countTotal : null;
    }

    @JsonIgnore
    public ConversationType getWhatsappConversationType() {
        return this.whatsapp != null && this.whatsapp.conversation != null && this.whatsapp.conversation.origin != null ? this.whatsapp.conversation.origin.type : null;
    }

    @JsonIgnore
    public String getWhatsappConversationId() {
        return this.whatsapp != null && this.whatsapp.conversation != null ? this.whatsapp.conversation.id : null;
    }

    @JsonAnyGetter
    public Map<String, ?> getAdditionalProperties() {
        return this.unknownProperties;
    }

    @JsonCreator
    public static MessageStatus fromJson(String json) {
        return (MessageStatus)Jsonable.fromJson((String)json, (Jsonable[])new MessageStatus[0]);
    }

    public static enum Status {
        SUBMITTED,
        DELIVERED,
        REJECTED,
        UNDELIVERABLE,
        READ;


        @JsonCreator
        public static Status fromString(String value) {
            if (value == null) {
                return null;
            }
            return Status.valueOf(value.toUpperCase());
        }

        @JsonValue
        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static final class Error
    extends JsonableBaseObject {
        @JsonProperty(value="type")
        URI type;
        @JsonProperty(value="title")
        String title;
        @JsonProperty(value="detail")
        String detail;
        @JsonProperty(value="instance")
        String instance;

        public URI getType() {
            return this.type;
        }

        public String getTitle() {
            return this.title;
        }

        public String getDetail() {
            return this.detail;
        }

        public String getInstance() {
            return this.instance;
        }
    }

    public static final class Usage
    extends JsonableBaseObject {
        @JsonProperty(value="price")
        double price;
        @JsonProperty(value="currency")
        Currency currency;

        void setCurrency(String currency) {
            this.currency = Currency.getInstance(currency);
        }

        public Currency getCurrency() {
            return this.currency;
        }

        void setPrice(String price) {
            this.price = Double.parseDouble(price);
        }

        public double getPrice() {
            return this.price;
        }
    }

    static class Destination
    extends JsonableBaseObject {
        @JsonProperty(value="network_code")
        String networkCode;

        Destination() {
        }
    }

    static class Sms
    extends JsonableBaseObject {
        @JsonProperty(value="count_total")
        Integer countTotal;

        Sms() {
        }
    }

    static class Whatsapp
    extends JsonableBaseObject {
        @JsonProperty(value="conversation")
        Conversation conversation;

        Whatsapp() {
        }

        static class Conversation
        extends JsonableBaseObject {
            @JsonProperty(value="id")
            String id;
            @JsonProperty(value="origin")
            Origin origin;

            Conversation() {
            }

            static class Origin
            extends JsonableBaseObject {
                @JsonProperty(value="type")
                ConversationType type;

                Origin() {
                }
            }
        }
    }
}

