/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.messages.internal;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.JsonableBaseObject;
import java.net.URI;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MessagePayload
extends JsonableBaseObject {
    protected URI url;
    protected String caption;
    protected String name;

    public MessagePayload(String url) {
        this.url = URI.create(Objects.requireNonNull(url, "URL is required."));
    }

    public MessagePayload(String url, String caption) {
        this(url);
        this.caption = caption;
        if (this.caption != null && caption.isEmpty()) {
            throw new IllegalArgumentException("Caption cannot be blank.");
        }
    }

    public MessagePayload(String url, String caption, String name) {
        this(url, caption);
        this.name = name;
    }

    @JsonProperty(value="url")
    public URI getUrl() {
        return this.url;
    }

    @JsonProperty(value="caption")
    public String getCaption() {
        return this.caption;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public static void validateExtension(String path, String ... allowed) {
        int lastDot = path.lastIndexOf(46);
        if (lastDot < 1) {
            return;
        }
        String ext = path.substring(lastDot + 1);
        Collection extensions = Stream.of(allowed).map(s -> s.startsWith(".") ? s.substring(1) : s).collect(Collectors.toSet());
        if (!extensions.contains(ext)) {
            throw new IllegalArgumentException("Invalid extension: '" + ext + "'. Should be one of " + extensions + '.');
        }
    }

    public void validateUrlExtension(String ... allowed) {
        MessagePayload.validateExtension(this.url.getPath(), allowed);
    }

    public void validateCaptionLength(int max) {
        if (this.caption == null) {
            return;
        }
        if (this.caption.length() > max) {
            throw new IllegalArgumentException("Caption must be less than " + max + " characters.");
        }
    }

    public void validateUrlLength(int min, int max) {
        if (this.url == null) {
            return;
        }
        int length = this.getUrl().toString().length();
        if (length < min) {
            throw new IllegalArgumentException("URL must be longer than " + min + " characters.");
        }
        if (length > max) {
            throw new IllegalArgumentException("URL must be less than " + max + " characters.");
        }
    }
}

