/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.subaccounts;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.JsonableBaseObject;
import com.vonage.client.subaccounts.AbstractTransfer;

public class UpdateSubaccountRequest
extends JsonableBaseObject {
    @JsonIgnore
    final String subaccountApiKey;
    private final String name;
    private final Boolean usePrimaryAccountBalance;
    private final Boolean suspended;

    UpdateSubaccountRequest(Builder builder) {
        this.subaccountApiKey = AbstractTransfer.validateAccountKey(builder.subaccountApiKey, "Subaccount");
        this.usePrimaryAccountBalance = builder.usePrimaryAccountBalance;
        this.suspended = builder.suspended;
        this.name = builder.name;
        if (this.name != null && (this.name.length() > 80 || this.name.trim().isEmpty())) {
            throw new IllegalArgumentException("Name must be between 1 and 80 characters long.");
        }
        if (this.name == null && this.usePrimaryAccountBalance == null && this.suspended == null) {
            throw new IllegalStateException("At least one property must be set for updating.");
        }
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="use_primary_account_balance")
    public Boolean getUsePrimaryAccountBalance() {
        return this.usePrimaryAccountBalance;
    }

    @JsonProperty(value="suspended")
    public Boolean getSuspended() {
        return this.suspended;
    }

    public static Builder builder(String subaccountApiKey) {
        return new Builder(subaccountApiKey);
    }

    public static class Builder {
        private final String subaccountApiKey;
        private String name;
        private Boolean usePrimaryAccountBalance;
        private Boolean suspended;

        Builder(String subaccountApiKey) {
            this.subaccountApiKey = subaccountApiKey;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder usePrimaryAccountBalance(boolean usePrimaryAccountBalance) {
            this.usePrimaryAccountBalance = usePrimaryAccountBalance;
            return this;
        }

        public Builder suspended(boolean suspended) {
            this.suspended = suspended;
            return this;
        }

        public UpdateSubaccountRequest build() {
            return new UpdateSubaccountRequest(this);
        }
    }
}

