/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.verify;

import com.fasterxml.jackson.annotation.JsonValue;
import com.vonage.client.verify.BaseRequest;
import java.util.Locale;
import java.util.Map;

public class VerifyRequest
extends BaseRequest {
    private final String brand;
    private final String from;
    private final String pinCode;
    private final Workflow workflow;

    public VerifyRequest(Builder builder) {
        super(builder.number, builder.length, builder.locale, builder.country, builder.pinExpiry, builder.nextEventWait);
        this.brand = builder.brand;
        if (this.brand != null && this.brand.length() > 18) {
            throw new IllegalArgumentException("Brand '" + this.brand + "' is longer than 18 characters.");
        }
        this.pinCode = builder.pinCode;
        if (this.pinCode != null && (this.pinCode.length() < 4 || this.pinCode.length() > 10)) {
            throw new IllegalArgumentException("Pin code must be between 4 and 10 characters.");
        }
        this.from = builder.senderId;
        this.workflow = builder.workflow;
    }

    public String getBrand() {
        return this.brand;
    }

    public String getFrom() {
        return this.from;
    }

    public Workflow getWorkflow() {
        return this.workflow;
    }

    public String getPinCode() {
        return this.pinCode;
    }

    @Override
    public Map<String, String> makeParams() {
        Map<String, String> params = super.makeParams();
        if (this.brand != null) {
            params.put("brand", this.brand);
        }
        if (this.from != null) {
            params.put("sender_id", this.from);
        }
        if (this.pinCode != null) {
            params.put("pin_code", this.pinCode);
        }
        if (this.workflow != null) {
            params.put("workflow_id", String.valueOf(this.workflow.id));
        }
        return params;
    }

    @Override
    public String toString() {
        return "VerifyRequest{" + super.toString() + ", brand='" + this.brand + '\'' + ", workflow=" + (Object)((Object)this.workflow) + '}';
    }

    public static Builder builder(String number, String brand) {
        return new Builder(number, brand);
    }

    public static class Builder {
        private String brand;
        private String senderId;
        private String number;
        private String country;
        private String pinCode;
        private Integer length;
        private Integer pinExpiry;
        private Integer nextEventWait;
        private Workflow workflow;
        private Locale locale;

        public Builder(String number, String brand) {
            this.number = number;
            this.brand = brand;
        }

        public Builder senderId(String senderId) {
            this.senderId = senderId;
            return this;
        }

        public Builder workflow(Workflow workflow) {
            this.workflow = workflow;
            return this;
        }

        public Builder locale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public Builder length(Integer length) {
            this.length = length;
            return this;
        }

        public Builder pinExpiry(Integer pinExpiry) {
            this.pinExpiry = pinExpiry;
            return this;
        }

        public Builder nextEventWait(Integer nextEventWait) {
            this.nextEventWait = nextEventWait;
            return this;
        }

        public Builder country(String country) {
            this.country = country;
            return this;
        }

        public Builder pinCode(String pinCode) {
            this.pinCode = pinCode;
            return this;
        }

        public VerifyRequest build() {
            return new VerifyRequest(this);
        }
    }

    public static enum Workflow {
        SMS_TTS_TTS(1),
        SMS_SMS_TTS(2),
        TTS_TTS(3),
        SMS_SMS(4),
        SMS_TTS(5),
        SMS(6),
        TTS(7);

        private final int id;

        private Workflow(int id) {
            this.id = id;
        }

        @JsonValue
        public int getId() {
            return this.id;
        }
    }
}

