/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.verify2;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.JsonableBaseObject;
import java.util.UUID;
import java.util.regex.Pattern;

public final class Template
extends JsonableBaseObject {
    private static final Pattern NAME_REGEX = Pattern.compile("^[a-zA-Z0-9_\\-]+$");
    private boolean isUpdateRequest;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="is_default")
    private Boolean isDefault;
    @JsonProperty(value="template_id")
    UUID id;

    private Template() {
    }

    Template(String name, Boolean isDefault, UUID id) {
        this.name = name;
        if (this.name != null && !NAME_REGEX.matcher(name).matches()) {
            throw new IllegalArgumentException("Invalid template name. Must match pattern: " + NAME_REGEX.pattern());
        }
        this.isDefault = isDefault;
        if (this.isDefault == null && name == null) {
            throw new IllegalArgumentException("Must provide at least one field to update.");
        }
        this.id = id;
        this.isUpdateRequest = true;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="template_id")
    public UUID getId() {
        return this.isUpdateRequest ? null : this.id;
    }

    @JsonProperty(value="is_default")
    public Boolean isDefault() {
        return this.isDefault;
    }

    @Override
    public void updateFromJson(String json) {
        this.isUpdateRequest = false;
        super.updateFromJson(json);
    }
}

