/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.verify2;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.util.StdConverter;
import com.vonage.client.JsonableBaseObject;
import com.vonage.client.verify2.FragmentChannel;
import java.time.Instant;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;

public final class TemplateFragment
extends JsonableBaseObject {
    @JsonIgnore
    private boolean isUpdateRequest;
    private String text;
    private Locale locale;
    private FragmentChannel channel;
    private Instant dateCreated;
    private Instant dateUpdated;
    UUID fragmentId;
    UUID templateId;

    TemplateFragment() {
    }

    TemplateFragment(String text, UUID templateId, UUID fragmentId) {
        this.text = Objects.requireNonNull(text, "Fragment text is required.");
        this.templateId = templateId;
        this.fragmentId = fragmentId;
        this.isUpdateRequest = true;
    }

    public TemplateFragment(FragmentChannel channel, String locale, String text) {
        this(text, null, null);
        this.channel = Objects.requireNonNull(channel, "Channel is required.");
        this.locale = Locale.forLanguageTag(Objects.requireNonNull(locale, "Locale is required."));
    }

    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    @JsonSerialize(converter=LocaleSerializer.class)
    @JsonProperty(value="locale")
    public Locale getLocale() {
        return this.locale;
    }

    @JsonProperty(value="channel")
    public FragmentChannel getChannel() {
        return this.channel;
    }

    @JsonProperty(value="template_fragment_id")
    public UUID getFragmentId() {
        return this.isUpdateRequest ? null : this.fragmentId;
    }

    @JsonIgnore
    public UUID getTemplateId() {
        return this.templateId;
    }

    @JsonProperty(value="date_created")
    public Instant getDateCreated() {
        return this.dateCreated;
    }

    @JsonProperty(value="date_updated")
    public Instant getDateUpdated() {
        return this.dateUpdated;
    }

    @Override
    public void updateFromJson(String json) {
        this.isUpdateRequest = false;
        super.updateFromJson(json);
    }

    private static final class LocaleSerializer
    extends StdConverter<Locale, String> {
        private LocaleSerializer() {
        }

        public String convert(Locale value) {
            return value == null ? null : value.toString().toLowerCase().replace('_', '-');
        }
    }
}

