/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.video;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.video.AbstractSessionTokenRequest;
import com.vonage.client.video.Language;
import java.net.URI;

public final class CaptionsRequest
extends AbstractSessionTokenRequest {
    private Language languageCode;
    private Integer maxDuration;
    private Boolean partialCaptions;
    private URI statusCallbackUrl;

    private CaptionsRequest() {
    }

    private CaptionsRequest(Builder builder) {
        super(builder);
        this.statusCallbackUrl = builder.statusCallbackUrl;
        this.languageCode = builder.languageCode;
        this.partialCaptions = builder.partialCaptions;
        this.maxDuration = builder.maxDuration;
        if (this.maxDuration != null && (this.maxDuration < 300 || this.maxDuration > 14400)) {
            throw new IllegalArgumentException("Max duration must be between 300 and 14400 seconds.");
        }
    }

    @JsonProperty(value="statusCallbackUrl")
    public URI getStatusCallbackUrl() {
        return this.statusCallbackUrl;
    }

    @JsonProperty(value="languageCode")
    public Language getLanguageCode() {
        return this.languageCode;
    }

    @JsonProperty(value="maxDuration")
    public Integer getMaxDuration() {
        return this.maxDuration;
    }

    @JsonProperty(value="partialCaptions")
    public Boolean partialCaptions() {
        return this.partialCaptions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractSessionTokenRequest.Builder<CaptionsRequest, Builder> {
        private URI statusCallbackUrl;
        private Language languageCode;
        private Integer maxDuration;
        private Boolean partialCaptions;

        private Builder() {
        }

        public Builder languageCode(Language languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        public Builder statusCallbackUrl(String statusCallbackUrl) {
            if (statusCallbackUrl == null || statusCallbackUrl.length() < 15 || statusCallbackUrl.length() > 2048) {
                throw new IllegalArgumentException("Status callback URL must be between 15 and 2048 characters.");
            }
            this.statusCallbackUrl = URI.create(statusCallbackUrl);
            return this;
        }

        public Builder maxDuration(int maxDuration) {
            this.maxDuration = maxDuration;
            return this;
        }

        public Builder partialCaptions(boolean partialCaptions) {
            this.partialCaptions = partialCaptions;
            return this;
        }

        @Override
        public CaptionsRequest build() {
            return new CaptionsRequest(this);
        }
    }
}

