/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.video;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.video.AbstractSessionTokenRequest;
import com.vonage.client.video.Websocket;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

public final class ConnectRequest
extends AbstractSessionTokenRequest {
    private Websocket websocket;

    private ConnectRequest() {
    }

    private ConnectRequest(Builder builder) {
        super(builder);
        this.websocket = new Websocket(builder);
    }

    @JsonProperty(value="websocket")
    public Websocket getWebsocket() {
        return this.websocket;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractSessionTokenRequest.Builder<ConnectRequest, Builder> {
        String uri;
        Collection<String> streams;
        Map<String, String> headers;
        Websocket.AudioRate audioRate;

        private Builder() {
        }

        @Override
        public Builder token(String token) {
            return (Builder)super.token(token);
        }

        @Override
        public Builder sessionId(String sessionId) {
            return (Builder)super.sessionId(sessionId);
        }

        public Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public Builder streams(String ... streams) {
            return this.streams(Arrays.asList(streams));
        }

        public Builder streams(Collection<String> streams) {
            this.streams = streams;
            return this;
        }

        public Builder headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Builder audioRate(Websocket.AudioRate audioRate) {
            this.audioRate = audioRate;
            return this;
        }

        @Override
        public ConnectRequest build() {
            return new ConnectRequest(this);
        }
    }
}

