/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.voice;

import com.vonage.client.QueryParamsRequest;
import com.vonage.client.voice.CallOrder;
import com.vonage.client.voice.CallStatus;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

public class CallsFilter
implements QueryParamsRequest {
    private final CallStatus status;
    private final Date dateStart;
    private final Date dateEnd;
    private final Integer pageSize;
    private final Integer recordIndex;
    private final CallOrder order;
    private final String conversationUuid;

    private CallsFilter(Builder builder) {
        this.status = builder.status;
        this.dateStart = builder.dateStart;
        this.dateEnd = builder.dateEnd;
        this.pageSize = builder.pageSize;
        this.recordIndex = builder.recordIndex;
        this.order = builder.order;
        this.conversationUuid = builder.conversationUuid;
    }

    public CallStatus getStatus() {
        return this.status;
    }

    public Date getDateStart() {
        return this.dateStart;
    }

    public Date getDateEnd() {
        return this.dateEnd;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public Integer getRecordIndex() {
        return this.recordIndex;
    }

    public CallOrder getOrder() {
        return this.order;
    }

    public String getConversationUuid() {
        return this.conversationUuid;
    }

    public Map<String, String> makeParams() {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        this.conditionalAdd(params, "status", (Object)this.status);
        this.conditionalAdd(params, "date_start", this.dateStart);
        this.conditionalAdd(params, "date_end", this.dateEnd);
        this.conditionalAdd(params, "page_size", this.pageSize);
        this.conditionalAdd(params, "record_index", this.recordIndex);
        this.conditionalAdd(params, "order", this.order != null ? this.order.getCallOrder() : null);
        this.conditionalAdd(params, "conversation_uuid", this.conversationUuid);
        return params;
    }

    private void conditionalAdd(Map<String, String> params, String name, String value) {
        if (value != null) {
            params.put(name, value);
        }
    }

    private void conditionalAdd(Map<String, String> params, String name, Date value) {
        if (value != null) {
            params.put(name, DateTimeFormatter.ISO_INSTANT.format(value.toInstant()));
        }
    }

    private void conditionalAdd(Map<String, String> params, String name, Object value) {
        if (value != null) {
            params.put(name, value.toString());
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private CallStatus status;
        private Date dateStart;
        private Date dateEnd;
        private Integer pageSize;
        private Integer recordIndex;
        private CallOrder order;
        private String conversationUuid;

        Builder() {
        }

        public Builder status(CallStatus status) {
            this.status = status;
            return this;
        }

        public Builder dateStart(Date dateStart) {
            this.dateStart = dateStart;
            return this;
        }

        public Builder dateEnd(Date dateEnd) {
            this.dateEnd = dateEnd;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Builder recordIndex(Integer recordIndex) {
            this.recordIndex = recordIndex;
            return this;
        }

        public Builder order(CallOrder order) {
            this.order = order;
            return this;
        }

        public Builder conversationUuid(String conversationUuid) {
            this.conversationUuid = conversationUuid;
            return this;
        }

        public CallsFilter build() {
            return new CallsFilter(this);
        }
    }
}

