/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client;

import com.vonage.client.HttpWrapper;
import com.vonage.client.RestEndpoint;
import com.vonage.client.VonageClientException;
import com.vonage.client.VonageMethodFailedException;
import com.vonage.client.VonageResponseParseException;
import com.vonage.client.VonageUnexpectedException;
import com.vonage.client.auth.ApiKeyQueryParamsAuthMethod;
import com.vonage.client.auth.AuthMethod;
import com.vonage.client.auth.HeaderAuthMethod;
import com.vonage.client.auth.QueryParamsAuthMethod;
import com.vonage.client.auth.RequestQueryParams;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;

public abstract class AbstractMethod<RequestT, ResultT>
implements RestEndpoint<RequestT, ResultT> {
    protected final HttpWrapper httpWrapper;

    public AbstractMethod(HttpWrapper httpWrapper) {
        this.httpWrapper = httpWrapper;
    }

    public HttpWrapper getHttpWrapper() {
        return this.httpWrapper;
    }

    protected ResultT postProcessParsedResponse(ResultT response) {
        return response;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ResultT execute(RequestT request) throws VonageResponseParseException, VonageClientException {
        HttpUriRequest httpRequest = this.applyAuth(this.makeRequest(request)).setHeader("User-Agent", this.httpWrapper.getUserAgent()).setCharset(StandardCharsets.UTF_8).build();
        try {
            CloseableHttpResponse response = this.httpWrapper.getHttpClient().execute(httpRequest);
            try {
                ResultT ResultT = this.postProcessParsedResponse(this.parseResponse((HttpResponse)response));
                return ResultT;
            }
            catch (IOException iox) {
                throw new VonageResponseParseException(iox);
            }
            finally {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        throwable2.addSuppressed(throwable);
                    }
                }
            }
        }
        catch (IOException iox) {
            throw new VonageMethodFailedException("Something went wrong while executing the HTTP request.", iox);
        }
    }

    final RequestBuilder applyAuth(RequestBuilder request) throws VonageClientException {
        AuthMethod am = this.getAuthMethod();
        if (am instanceof HeaderAuthMethod) {
            request.setHeader("Authorization", ((HeaderAuthMethod)am).getHeaderValue());
        }
        if (am instanceof QueryParamsAuthMethod) {
            RequestQueryParams qp = am instanceof ApiKeyQueryParamsAuthMethod ? null : AbstractMethod.normalRequestParams(request);
            ((QueryParamsAuthMethod)am).getAuthParams(qp).forEach((arg_0, arg_1) -> ((RequestBuilder)request).addParameter(arg_0, arg_1));
        }
        return request;
    }

    static RequestQueryParams normalRequestParams(RequestBuilder request) {
        return request.getParameters().stream().map(nvp -> new AbstractMap.SimpleEntry<String, String>(nvp.getName(), nvp.getValue())).collect(Collectors.toCollection(RequestQueryParams::new));
    }

    protected AuthMethod getAuthMethod() throws VonageUnexpectedException {
        return this.httpWrapper.getAuthCollection().getAcceptableAuthMethod(this.getAcceptableAuthMethods());
    }

    protected abstract Set<Class<? extends AuthMethod>> getAcceptableAuthMethods();

    protected abstract RequestBuilder makeRequest(RequestT var1);

    protected abstract ResultT parseResponse(HttpResponse var1) throws IOException;

    static {
        LogFactory.getLog(AbstractMethod.class);
    }
}

