/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client;

import com.vonage.client.ApiRegion;
import java.net.URI;
import java.util.Objects;
import java.util.function.Function;

public class HttpConfig {
    private static final String DEFAULT_API_BASE_URI = "https://api.nexmo.com";
    private static final String DEFAULT_REST_BASE_URI = "https://rest.nexmo.com";
    private static final String DEFAULT_API_EU_BASE_URI = "https://api-eu.vonage.com";
    private static final String DEFAULT_VIDEO_BASE_URI = "https://video.api.vonage.com";
    private final int timeoutMillis;
    private final String customUserAgent;
    private final String apiBaseUri;
    private final String restBaseUri;
    private final String apiEuBaseUri;
    private final String videoBaseUri;
    private final Function<ApiRegion, String> regionalUriGetter;
    private final URI proxy;

    private HttpConfig(Builder builder) {
        this.timeoutMillis = builder.timeoutMillis;
        if (this.timeoutMillis < 10) {
            throw new IllegalArgumentException("Timeout must be greater than 10ms.");
        }
        this.proxy = builder.proxy;
        this.apiBaseUri = builder.apiBaseUri;
        this.restBaseUri = builder.restBaseUri;
        this.videoBaseUri = builder.videoBaseUri;
        this.apiEuBaseUri = builder.apiEuBaseUri;
        this.regionalUriGetter = builder.regionalUriGetter;
        this.customUserAgent = builder.customUserAgent;
    }

    public int getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public String getApiBaseUri() {
        return this.apiBaseUri;
    }

    public String getRestBaseUri() {
        return this.restBaseUri;
    }

    public String getVideoBaseUri() {
        return this.videoBaseUri;
    }

    public String getApiEuBaseUri() {
        return this.apiEuBaseUri;
    }

    public URI getRegionalBaseUri(ApiRegion region) {
        return URI.create(this.regionalUriGetter.apply(region));
    }

    public String getCustomUserAgent() {
        return this.customUserAgent;
    }

    public URI getProxy() {
        return this.proxy;
    }

    @Deprecated
    public boolean isDefaultApiBaseUri() {
        return DEFAULT_API_BASE_URI.equals(this.apiBaseUri);
    }

    @Deprecated
    public boolean isDefaultRestBaseUri() {
        return DEFAULT_REST_BASE_URI.equals(this.restBaseUri);
    }

    @Deprecated
    public boolean isDefaultApiEuBaseUri() {
        return DEFAULT_API_EU_BASE_URI.equals(this.apiEuBaseUri);
    }

    @Deprecated
    public boolean isDefaultVideoBaseUri() {
        return DEFAULT_VIDEO_BASE_URI.equals(this.videoBaseUri);
    }

    @Deprecated
    public String getVersionedApiBaseUri(String version) {
        return this.appendVersionToUri(this.apiBaseUri, version);
    }

    @Deprecated
    public String getVersionedRestBaseUri(String version) {
        return this.appendVersionToUri(this.restBaseUri, version);
    }

    @Deprecated
    public String getVersionedApiEuBaseUri(String version) {
        return this.appendVersionToUri(this.apiEuBaseUri, version);
    }

    @Deprecated
    public String getVersionedVideoBaseUri(String version) {
        return this.appendVersionToUri(this.videoBaseUri, version);
    }

    private String appendVersionToUri(String uri, String version) {
        return uri + "/" + version;
    }

    public static HttpConfig defaultConfig() {
        return HttpConfig.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int timeoutMillis = 60000;
        private URI proxy;
        private Function<ApiRegion, String> regionalUriGetter = region -> "https://" + (Object)region + ".vonage.com";
        private String customUserAgent;
        private String apiBaseUri = "https://api.nexmo.com";
        private String restBaseUri = "https://rest.nexmo.com";
        private String apiEuBaseUri = "https://api-eu.vonage.com";
        private String videoBaseUri = "https://video.api.vonage.com";

        @Deprecated
        public Builder() {
        }

        private String sanitizeUri(String uri) {
            if (uri != null && uri.endsWith("/")) {
                return uri.substring(0, uri.length() - 1);
            }
            return uri;
        }

        public Builder timeoutMillis(int timeoutMillis) {
            this.timeoutMillis = timeoutMillis;
            return this;
        }

        public Builder proxy(String proxy) {
            return this.proxy(URI.create(proxy));
        }

        public Builder proxy(URI proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder apiBaseUri(String apiBaseUri) {
            this.apiBaseUri = this.sanitizeUri(apiBaseUri);
            return this;
        }

        public Builder restBaseUri(String restBaseUri) {
            this.restBaseUri = this.sanitizeUri(restBaseUri);
            return this;
        }

        public Builder apiEuBaseUri(String apiEuBaseUri) {
            this.apiEuBaseUri = this.sanitizeUri(apiEuBaseUri);
            return this;
        }

        public Builder videoBaseUri(String videoBaseUri) {
            this.videoBaseUri = this.sanitizeUri(videoBaseUri);
            return this;
        }

        public Builder baseUri(String baseUri) {
            String sanitizedUri = this.sanitizeUri(baseUri);
            this.regionalUriGetter(region -> sanitizedUri.replace("://", "://" + (Object)region + '.'));
            this.apiBaseUri = sanitizedUri;
            this.restBaseUri = sanitizedUri;
            this.apiEuBaseUri = sanitizedUri;
            this.videoBaseUri = sanitizedUri;
            return this;
        }

        public Builder baseUri(URI baseUri) {
            return this.baseUri(baseUri.toString());
        }

        public Builder regionalUriGetter(Function<ApiRegion, String> uriGetter) {
            this.regionalUriGetter = Objects.requireNonNull(uriGetter);
            return this;
        }

        public Builder appendUserAgent(String userAgent) {
            this.customUserAgent = Objects.requireNonNull(userAgent).trim();
            if (this.customUserAgent.length() > 127) {
                throw new IllegalArgumentException("User agent string must be less than 128 characters in length.");
            }
            if (this.customUserAgent.isEmpty()) {
                throw new IllegalArgumentException("Custom user agent string cannot be blank.");
            }
            return this;
        }

        public HttpConfig build() {
            return new HttpConfig(this);
        }
    }
}

