/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.application;

import com.vonage.client.DynamicEndpoint;
import com.vonage.client.HttpWrapper;
import com.vonage.client.RestEndpoint;
import com.vonage.client.application.Application;
import com.vonage.client.application.ApplicationList;
import com.vonage.client.application.ApplicationResponseException;
import com.vonage.client.application.ListApplicationRequest;
import com.vonage.client.auth.ApiKeyHeaderAuthMethod;
import com.vonage.client.common.HttpMethod;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;

public class ApplicationClient {
    final RestEndpoint<ListApplicationRequest, ApplicationList> listApplications;
    final RestEndpoint<Application, Application> createApplication;
    final RestEndpoint<UUID, Application> getApplication;
    final RestEndpoint<Application, Application> updateApplication;
    final RestEndpoint<UUID, Void> deleteApplication;

    public ApplicationClient(final HttpWrapper wrapper) {
        final class Endpoint<T, R>
        extends DynamicEndpoint<T, R> {
            Endpoint(Function<T, String> pathGetter, HttpMethod method, R ... type) {
                super(DynamicEndpoint.builder(type).responseExceptionType(ApplicationResponseException.class).wrapper(var5_5).requestMethod(method).authMethod(ApiKeyHeaderAuthMethod.class, new Class[0]).pathGetter((de, req) -> {
                    String base = de.getHttpWrapper().getHttpConfig().getVersionedApiBaseUri("v2");
                    String path = base + "/applications";
                    if (pathGetter != null) {
                        path = path + "/" + (String)pathGetter.apply(req);
                    }
                    return path;
                }));
            }
        }
        this.listApplications = new Endpoint(null, HttpMethod.GET, (Object[])new ApplicationList[0]);
        this.createApplication = new Endpoint(null, HttpMethod.POST, (Object[])new Application[0]);
        this.getApplication = new Endpoint(UUID::toString, HttpMethod.GET, (Object[])new Application[0]);
        this.updateApplication = new Endpoint(Application::getId, HttpMethod.PUT, (Object[])new Application[0]);
        this.deleteApplication = new Endpoint(UUID::toString, HttpMethod.DELETE, (Object[])new Void[0]);
    }

    private Application validateApplication(Application request) {
        return Objects.requireNonNull(request, "Application request is required.");
    }

    private UUID validateApplicationId(String id) {
        return UUID.fromString(Objects.requireNonNull(id, "Application ID is required."));
    }

    public Application createApplication(Application application) throws ApplicationResponseException {
        return this.createApplication.execute(this.validateApplication(application));
    }

    public Application updateApplication(Application application) throws ApplicationResponseException {
        return this.updateApplication.execute(this.validateApplication(application));
    }

    public Application getApplication(String applicationId) throws ApplicationResponseException {
        return this.getApplication.execute(this.validateApplicationId(applicationId));
    }

    public void deleteApplication(String applicationId) throws ApplicationResponseException {
        this.deleteApplication.execute(this.validateApplicationId(applicationId));
    }

    public List<Application> listAllApplications() throws ApplicationResponseException {
        return this.listApplications(ListApplicationRequest.builder().pageSize(1000L).build()).getApplications();
    }

    public ApplicationList listApplications() throws ApplicationResponseException {
        return this.listApplications(ListApplicationRequest.builder().build());
    }

    public ApplicationList listApplications(ListApplicationRequest listApplicationRequest) throws ApplicationResponseException {
        return this.listApplications.execute(listApplicationRequest);
    }
}

