/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.application.capabilities;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.application.capabilities.Capability;
import java.net.URI;

public final class NetworkApis
extends Capability {
    private URI redirectUri;
    private String networkApplicationId;

    private NetworkApis() {
    }

    private NetworkApis(Builder builder) {
        super(builder);
        this.redirectUri = builder.redirectUri;
        this.networkApplicationId = builder.networkApplicationId;
    }

    @Override
    public Capability.Type getType() {
        return Capability.Type.NETWORK;
    }

    @JsonProperty(value="redirect_uri")
    public URI getRedirectUri() {
        return this.redirectUri;
    }

    @JsonProperty(value="network_application_id")
    public String getNetworkApplicationId() {
        return this.networkApplicationId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Capability.Builder<NetworkApis, Builder> {
        private URI redirectUri;
        private String networkApplicationId;

        private Builder() {
        }

        public Builder redirectUri(String redirectUri) {
            return this.redirectUri(URI.create(redirectUri));
        }

        public Builder redirectUri(URI redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        public Builder networkApplicationId(String networkApplicationId) {
            this.networkApplicationId = networkApplicationId;
            return this;
        }

        @Override
        public NetworkApis build() {
            return new NetworkApis(this);
        }
    }
}

