/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.auth;

import com.vonage.client.auth.ApiKeyHeaderAuthMethod;
import com.vonage.client.auth.ApiKeyQueryParamsAuthMethod;
import com.vonage.client.auth.AuthMethod;
import com.vonage.client.auth.JWTAuthMethod;
import com.vonage.client.auth.NoAuthMethod;
import com.vonage.client.auth.SignatureAuthMethod;
import com.vonage.client.auth.VonageUnacceptableAuthException;
import com.vonage.client.auth.hashutils.HashUtil;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.Function;

public class AuthCollection {
    private final SortedSet<AuthMethod> authList;

    public AuthCollection() {
        this(new TreeSet<AuthMethod>());
    }

    public AuthCollection(AuthMethod ... authMethods) {
        this(new TreeSet<AuthMethod>(Arrays.asList(authMethods)));
    }

    public AuthCollection(SortedSet<AuthMethod> authMethods) {
        this.authList = authMethods;
    }

    public AuthCollection(UUID applicationId, byte[] privateKeyContents, String key, String secret, HashUtil.HashType hashType, String signature) {
        this();
        if (key != null && secret == null && signature == null) {
            throw new IllegalStateException("You must provide an API secret or signature secret in addition to your API key.");
        }
        if (secret != null && key == null) {
            throw new IllegalStateException("You must provide an API key in addition to your API secret.");
        }
        if (signature != null && key == null) {
            throw new IllegalStateException("You must provide an API key in addition to your signature secret.");
        }
        if (applicationId == null && privateKeyContents != null) {
            throw new IllegalStateException("You must provide an application ID in addition to your private key.");
        }
        if (applicationId != null && privateKeyContents == null) {
            throw new IllegalStateException("You must provide a private key in addition to your application id.");
        }
        this.authList.add(new NoAuthMethod());
        if (key != null && secret != null) {
            this.authList.add(new ApiKeyHeaderAuthMethod(key, secret));
            this.authList.add(new ApiKeyQueryParamsAuthMethod(key, secret));
        }
        if (key != null && signature != null) {
            this.authList.add(new SignatureAuthMethod(key, signature, hashType));
        }
        if (applicationId != null) {
            this.authList.add(new JWTAuthMethod(applicationId.toString(), privateKeyContents));
        }
    }

    public void add(AuthMethod auth) {
        this.authList.remove(auth);
        this.authList.add(auth);
    }

    public <T extends AuthMethod> T getAuth(Class<T> type) throws VonageUnacceptableAuthException {
        for (AuthMethod availableAuthMethod : this.authList) {
            if (!type.isInstance(availableAuthMethod)) continue;
            return (T)availableAuthMethod;
        }
        throw new VonageUnacceptableAuthException(this.authList, Collections.singletonList(type));
    }

    public AuthMethod getAcceptableAuthMethod(Set<Class<? extends AuthMethod>> acceptableAuthMethodClasses) throws VonageUnacceptableAuthException {
        for (AuthMethod availableAuthMethod : this.authList) {
            for (Class<? extends AuthMethod> acceptable : acceptableAuthMethodClasses) {
                if (!acceptable.isAssignableFrom(availableAuthMethod.getClass())) continue;
                return availableAuthMethod;
            }
        }
        throw new VonageUnacceptableAuthException(this.authList, acceptableAuthMethodClasses);
    }

    public boolean hasAuthMethod(Class<? extends AuthMethod> authMethod) {
        return this.authList.stream().map((Function<AuthMethod, Class>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getClass(), (Lcom/vonage/client/auth/AuthMethod;)Ljava/lang/Class;)()).anyMatch(authMethod::equals);
    }
}

