/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.auth;

import com.vonage.client.auth.AbstractApiKeyQueryParamsAuthMethod;
import com.vonage.client.auth.RequestQueryParams;
import com.vonage.client.auth.RequestSigning;
import com.vonage.client.auth.hashutils.HashUtil;
import java.util.Map;

public class SignatureAuthMethod
extends AbstractApiKeyQueryParamsAuthMethod {
    private static final int SORT_KEY = 20;
    private final String sigSecret;
    private final HashUtil.HashType hashType;

    public SignatureAuthMethod(String apiKey, String sigSecret) {
        this(apiKey, sigSecret, HashUtil.HashType.MD5);
    }

    public SignatureAuthMethod(String apiKey, String sigSecret, HashUtil.HashType hashType) {
        super(apiKey);
        this.sigSecret = sigSecret;
        this.hashType = hashType;
    }

    @Override
    public int getSortKey() {
        return 20;
    }

    @Override
    public Map<String, String> getAuthParams(RequestQueryParams requestParams) {
        Map<String, String> inParams = requestParams.toMap();
        Map<String, String> outParams = super.getAuthParams(requestParams);
        inParams.putAll(outParams);
        outParams.putAll(RequestSigning.getSignatureForRequestParameters(inParams, this.sigSecret, this.hashType));
        return outParams;
    }
}

