/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.auth.camara;

import com.vonage.client.DynamicEndpoint;
import com.vonage.client.HttpWrapper;
import com.vonage.client.RestEndpoint;
import com.vonage.client.auth.JWTAuthMethod;
import com.vonage.client.auth.camara.BackendAuthRequest;
import com.vonage.client.auth.camara.BackendAuthResponse;
import com.vonage.client.auth.camara.NetworkAuthResponseException;
import com.vonage.client.auth.camara.TokenRequest;
import com.vonage.client.auth.camara.TokenResponse;
import com.vonage.client.common.HttpMethod;
import java.util.Objects;

public class NetworkAuthClient {
    final RestEndpoint<BackendAuthRequest, BackendAuthResponse> backendAuth;
    final RestEndpoint<TokenRequest, TokenResponse> tokenRequest;

    public NetworkAuthClient(final HttpWrapper wrapper) {
        final class Endpoint<T, R>
        extends DynamicEndpoint<T, R> {
            Endpoint(String path, HttpMethod method, R ... type) {
                super(DynamicEndpoint.builder(type).responseExceptionType(NetworkAuthResponseException.class).wrapper(var5_5).requestMethod(method).urlFormEncodedContentType(true).authMethod(JWTAuthMethod.class, new Class[0]).pathGetter((de, req) -> de.getHttpWrapper().getHttpConfig().getApiEuBaseUri() + "/oauth2/" + path));
            }
        }
        this.backendAuth = new Endpoint("bc-authorize", HttpMethod.POST, (Object[])new BackendAuthResponse[0]);
        this.tokenRequest = new Endpoint("token", HttpMethod.POST, (Object[])new TokenResponse[0]);
    }

    private <R> R validateRequest(R request) {
        return Objects.requireNonNull(request, "Request is required.");
    }

    public BackendAuthResponse buildOidcUrl(BackendAuthRequest request) {
        return this.backendAuth.execute(this.validateRequest(request));
    }

    public TokenResponse getCamaraToken(TokenRequest request) {
        return this.tokenRequest.execute(this.validateRequest(request));
    }
}

