/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.camara.numberverification;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.JsonableBaseObject;
import com.vonage.client.common.E164;
import java.net.URI;
import java.util.Objects;

class VerifyNumberRequest
extends JsonableBaseObject {
    private final String phoneNumber;
    @JsonIgnore
    final URI redirectUrl;
    @JsonIgnore
    private String code;

    VerifyNumberRequest(String phoneNumber, URI redirectUrl) {
        this.phoneNumber = '+' + new E164(phoneNumber).toString();
        this.redirectUrl = Objects.requireNonNull(redirectUrl, "Redirect URL is required.");
    }

    @JsonIgnore
    VerifyNumberRequest withCode(String code) {
        this.code = Objects.requireNonNull(code, "Code is required.");
        return this;
    }

    @JsonIgnore
    String getCode() {
        return this.code;
    }

    @JsonProperty(value="phoneNumber")
    public String getPhoneNumber() {
        return this.phoneNumber;
    }
}

