/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.camara.simswap;

import com.vonage.client.DynamicEndpoint;
import com.vonage.client.HttpWrapper;
import com.vonage.client.RestEndpoint;
import com.vonage.client.auth.camara.BackendAuthRequest;
import com.vonage.client.auth.camara.FraudPreventionDetectionScope;
import com.vonage.client.auth.camara.NetworkAuthMethod;
import com.vonage.client.camara.CamaraResponseException;
import com.vonage.client.camara.NetworkApiClient;
import com.vonage.client.camara.simswap.CheckSimSwapResponse;
import com.vonage.client.camara.simswap.SimSwapDateResponse;
import com.vonage.client.camara.simswap.SimSwapRequest;
import com.vonage.client.common.HttpMethod;
import java.time.Instant;

public class SimSwapClient
extends NetworkApiClient {
    final RestEndpoint<SimSwapRequest, CheckSimSwapResponse> check;
    final RestEndpoint<SimSwapRequest, SimSwapDateResponse> retrieveDate;

    public SimSwapClient(final HttpWrapper wrapper) {
        super(wrapper);
        class Endpoint<R>
        extends DynamicEndpoint<SimSwapRequest, R> {
            Endpoint(String path, FraudPreventionDetectionScope scope, R ... type) {
                super(DynamicEndpoint.builder(type).authMethod(NetworkAuthMethod.class, new Class[0]).responseExceptionType(CamaraResponseException.class).requestMethod(HttpMethod.POST).wrapper(var5_5).pathGetter((de, req) -> {
                    ((SimSwapClient)this$0).setNetworkAuth(new BackendAuthRequest(req.getPhoneNumber(), scope));
                    return ((SimSwapClient)this$0).getCamaraBaseUri() + "sim-swap/v040/" + path;
                }));
            }
        }
        this.check = new Endpoint("check", FraudPreventionDetectionScope.CHECK_SIM_SWAP, (Object[])new CheckSimSwapResponse[0]);
        this.retrieveDate = new Endpoint("retrieve-date", FraudPreventionDetectionScope.RETRIEVE_SIM_SWAP_DATE, (Object[])new SimSwapDateResponse[0]);
    }

    private boolean checkSimSwap(SimSwapRequest request) {
        return this.check.execute(request).getSwapped();
    }

    public boolean checkSimSwap(String phoneNumber) {
        return this.checkSimSwap(new SimSwapRequest(phoneNumber));
    }

    public boolean checkSimSwap(String phoneNumber, int maxAgeHours) {
        return this.checkSimSwap(new SimSwapRequest(phoneNumber, maxAgeHours));
    }

    public Instant retrieveSimSwapDate(String phoneNumber) {
        return this.retrieveDate.execute(new SimSwapRequest(phoneNumber)).getLatestSimChange();
    }
}

