/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum ChannelType {
    APP,
    PHONE,
    SMS,
    MMS,
    SIP,
    VBC,
    WEBSOCKET,
    VIBER,
    MESSENGER,
    WHATSAPP,
    WHATSAPP_VOICE;


    @JsonCreator
    public static ChannelType fromString(String name) {
        try {
            String normal = name.toUpperCase().replace('-', '_');
            return "PSTN".equals(normal) ? PHONE : ChannelType.valueOf(normal);
        }
        catch (IllegalArgumentException | NullPointerException ex) {
            return null;
        }
    }

    @JsonValue
    public String toString() {
        return this.name().toLowerCase().replace('_', '-');
    }
}

