/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.vonage.client.JsonableBaseObject;
import com.vonage.client.common.HttpMethod;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

@Deprecated
public class Webhook
extends JsonableBaseObject {
    private String address;
    private HttpMethod method;
    private Integer connectionTimeout;
    private Integer socketTimeout;

    private Webhook(Builder builder) {
        int max;
        int min;
        this.address = builder.address;
        if (this.address == null || this.address.trim().isEmpty()) {
            throw new IllegalStateException("Address is required.");
        }
        this.method = builder.method;
        if (this.method == null) {
            throw new IllegalStateException("HTTP method is required.");
        }
        this.connectionTimeout = builder.connectionTimeout;
        if (this.connectionTimeout != null) {
            min = 300;
            max = 1000;
            if (this.connectionTimeout < min || this.connectionTimeout > max) {
                throw new IllegalArgumentException("Connection timeout must be between " + min + " and " + max + " milliseconds.");
            }
        }
        if ((this.socketTimeout = builder.socketTimeout) != null) {
            min = 1000;
            max = 10000;
            if (this.socketTimeout < min || this.socketTimeout > max) {
                throw new IllegalArgumentException("Socket timeout must be between " + min + " and " + max + " milliseconds.");
            }
        }
    }

    protected Webhook() {
    }

    public Webhook(String address, HttpMethod method) {
        this.address = address;
        this.method = method;
    }

    @JsonProperty(value="address")
    public String getAddress() {
        return this.address;
    }

    @JsonProperty(value="http_method")
    public HttpMethod getMethod() {
        return this.method;
    }

    @JsonProperty(value="connection_timeout")
    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @JsonProperty(value="socket_timeout")
    public Integer getSocketTimeout() {
        return this.socketTimeout;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String address;
        private HttpMethod method;
        private Integer connectionTimeout;
        private Integer socketTimeout;

        Builder() {
        }

        public Builder address(String address) {
            this.address = address;
            return this;
        }

        public Builder method(HttpMethod method) {
            this.method = method;
            return this;
        }

        public Builder connectionTimeout(int connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public Builder socketTimeout(int socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        public Webhook build() {
            return new Webhook(this);
        }
    }

    public static enum Type {
        ANSWER("answer_url"),
        FALLBACK_ANSWER("fallback_answer_url"),
        EVENT("event_url"),
        INBOUND("inbound_url"),
        STATUS("status_url"),
        UNKNOWN("unknown");

        private final String name;
        private static final Map<String, Type> TYPE_INDEX;

        private Type(String name) {
            this.name = name;
        }

        @JsonValue
        public String getName() {
            return this.name;
        }

        @JsonCreator
        public static Type fromName(String name) {
            return TYPE_INDEX.getOrDefault(name.toLowerCase(), UNKNOWN);
        }

        static {
            TYPE_INDEX = Arrays.stream(Type.values()).collect(Collectors.toMap(Type::getName, Function.identity()));
        }
    }
}

