/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.conversations;

import com.vonage.client.common.HalFilterRequest;
import com.vonage.client.common.SortOrder;
import java.time.Instant;
import java.util.Map;

abstract class AbstractConversationsFilterRequest
extends HalFilterRequest {
    String conversationId;

    protected AbstractConversationsFilterRequest(Builder<? extends AbstractConversationsFilterRequest, ? extends Builder<?, ?>> builder) {
        super(builder);
    }

    @Override
    protected Integer validatePageSize(Integer pageSize) {
        if (pageSize != null && (pageSize < 1 || pageSize > 100)) {
            throw new IllegalArgumentException("Page size must be between 1 and 100.");
        }
        return pageSize;
    }

    protected String formatTimestamp(Instant time) {
        return time.toString().replace('T', ' ').replace("Z", "");
    }

    @Override
    public String getCursor() {
        return super.getCursor();
    }

    @Override
    public Map<String, String> makeParams() {
        Map<String, String> params = super.makeParams();
        if (this.startDate != null) {
            params.put("date_start", this.formatTimestamp(this.startDate));
        }
        if (this.endDate != null) {
            params.put("date_end", this.formatTimestamp(this.endDate));
        }
        return params;
    }

    @Override
    public Integer getPageSize() {
        return super.getPageSize();
    }

    @Override
    public SortOrder getOrder() {
        return super.getOrder();
    }

    protected static abstract class Builder<F extends AbstractConversationsFilterRequest, B extends Builder<? extends F, ? extends B>>
    extends HalFilterRequest.Builder<F, B> {
        Builder() {
        }

        @Override
        public B pageSize(int pageSize) {
            return (B)((Builder)super.pageSize(pageSize));
        }

        @Override
        public B order(SortOrder order) {
            return (B)((Builder)super.order(order));
        }

        @Override
        public B cursor(String cursor) {
            return (B)((Builder)super.cursor(cursor));
        }
    }
}

