/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.conversations;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.JsonableBaseObject;
import com.vonage.client.conversations.Event;
import com.vonage.client.conversations.EventType;
import com.vonage.client.conversations.EventWithBody;

abstract class AudioOutEvent<T extends Body>
extends EventWithBody<T> {
    AudioOutEvent() {
    }

    AudioOutEvent(Builder<? extends AudioOutEvent<? extends T>, ?> builder) {
        super(builder);
    }

    @JsonIgnore
    public Boolean getQueue() {
        return this.body != null ? ((Body)this.body).queue : null;
    }

    @JsonIgnore
    public Double getLevel() {
        return this.body != null ? ((Body)this.body).level : null;
    }

    @JsonIgnore
    public Integer getLoop() {
        return this.body != null ? ((Body)this.body).loop : null;
    }

    public static class Body
    extends JsonableBaseObject {
        @JsonProperty(value="queue")
        Boolean queue;
        @JsonProperty(value="level")
        Double level;
        @JsonProperty(value="loop")
        Integer loop;

        Body() {
        }

        Body(Builder<?, ?> builder) {
            this.queue = builder.queue;
            this.level = builder.level;
            if (this.level != null && (this.level > 1.0 || this.level < -1.0)) {
                throw new IllegalArgumentException("Level must be between -1 and 1.");
            }
            this.loop = builder.loop;
            if (this.loop != null && this.loop < 0) {
                throw new IllegalArgumentException("Loop cannot be negative.");
            }
        }
    }

    static abstract class Builder<E extends AudioOutEvent<?>, B extends Builder<? extends E, ? extends B>>
    extends Event.Builder<E, B> {
        Boolean queue;
        Double level;
        Integer loop;

        Builder(EventType type) {
            super(type);
        }

        public B queue(boolean queue) {
            this.queue = queue;
            return (B)this;
        }

        public B level(double level) {
            this.level = level;
            return (B)this;
        }

        public B loop(int loop) {
            this.loop = loop;
            return (B)this;
        }
    }
}

