/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.conversations;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.vonage.client.conversations.AudioOutEvent;
import com.vonage.client.conversations.AudioPlayEventBody;
import com.vonage.client.conversations.EventType;
import java.net.URI;
import java.util.UUID;

public final class AudioPlayEvent
extends AudioOutEvent<AudioPlayEventBody> {
    AudioPlayEvent() {
    }

    private AudioPlayEvent(Builder builder) {
        super(builder);
        this.body = new AudioPlayEventBody(builder);
    }

    @JsonIgnore
    public UUID getPlayId() {
        return this.body != null ? ((AudioPlayEventBody)this.body).playId : null;
    }

    @JsonIgnore
    public URI getStreamUrl() {
        return this.body != null && ((AudioPlayEventBody)this.body).streamUrl != null && ((AudioPlayEventBody)this.body).streamUrl.length > 0 ? ((AudioPlayEventBody)this.body).streamUrl[0] : null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AudioOutEvent.Builder<AudioPlayEvent, Builder> {
        URI[] streamUrl;

        Builder() {
            super(EventType.AUDIO_PLAY);
        }

        public Builder streamUrl(String streamUrl) {
            return this.streamUrl(URI.create(streamUrl));
        }

        public Builder streamUrl(URI streamUrl) {
            this.streamUrl = new URI[]{streamUrl};
            return this;
        }

        @Override
        public AudioPlayEvent build() {
            return new AudioPlayEvent(this);
        }
    }
}

