/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.conversations;

import com.vonage.client.DynamicEndpoint;
import com.vonage.client.HttpWrapper;
import com.vonage.client.RestEndpoint;
import com.vonage.client.auth.JWTAuthMethod;
import com.vonage.client.common.HttpMethod;
import com.vonage.client.conversations.AbstractConversationsFilterRequest;
import com.vonage.client.conversations.BaseConversation;
import com.vonage.client.conversations.BaseMember;
import com.vonage.client.conversations.Conversation;
import com.vonage.client.conversations.ConversationResourceRequestWrapper;
import com.vonage.client.conversations.ConversationsResponseException;
import com.vonage.client.conversations.Event;
import com.vonage.client.conversations.ListConversationsRequest;
import com.vonage.client.conversations.ListConversationsResponse;
import com.vonage.client.conversations.ListEventsRequest;
import com.vonage.client.conversations.ListEventsResponse;
import com.vonage.client.conversations.ListMembersRequest;
import com.vonage.client.conversations.ListMembersResponse;
import com.vonage.client.conversations.ListUserConversationsRequest;
import com.vonage.client.conversations.ListUserConversationsResponse;
import com.vonage.client.conversations.Member;
import com.vonage.client.conversations.UpdateMemberRequest;
import com.vonage.client.conversations.UserConversation;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;

public class ConversationsClient {
    final RestEndpoint<ListConversationsRequest, ListConversationsResponse> listConversations;
    final RestEndpoint<Conversation, Conversation> createConversation;
    final RestEndpoint<String, Conversation> getConversation;
    final RestEndpoint<Conversation, Conversation> updateConversation;
    final RestEndpoint<String, Void> deleteConversation;
    final RestEndpoint<ListUserConversationsRequest, ListUserConversationsResponse> listUserConversations;
    final RestEndpoint<ListMembersRequest, ListMembersResponse> listMembers;
    final RestEndpoint<ConversationResourceRequestWrapper, Member> getMember;
    final RestEndpoint<Member, Member> createMember;
    final RestEndpoint<UpdateMemberRequest, Member> updateMember;
    final RestEndpoint<ConversationResourceRequestWrapper, Void> deleteEvent;
    final RestEndpoint<ConversationResourceRequestWrapper, Event> getEvent;
    final RestEndpoint<ListEventsRequest, ListEventsResponse> listEvents;
    final RestEndpoint<Event, Event> createEvent;

    public ConversationsClient(final HttpWrapper wrapper) {
        String v1c = "/v1/conversations/";
        String v1u = "/v1/users/";
        String mems = "/members/";
        String events = "/events/";
        class Endpoint<T, R>
        extends DynamicEndpoint<T, R> {
            Endpoint(Function<T, String> pathGetter, HttpMethod method, R ... type) {
                super(DynamicEndpoint.builder(type).authMethod(JWTAuthMethod.class, new Class[0]).responseExceptionType(ConversationsResponseException.class).requestMethod(method).wrapper(var5_5).pathGetter((de, req) -> {
                    String base = de.getHttpWrapper().getHttpConfig().getApiBaseUri();
                    return base + (String)pathGetter.apply(req);
                }));
            }
        }
        this.listConversations = new Endpoint(req -> "/v1/conversations/", HttpMethod.GET, (Object[])new ListConversationsResponse[0]);
        this.createConversation = new Endpoint(req -> "/v1/conversations/", HttpMethod.POST, (Object[])new Conversation[0]);
        this.getConversation = new Endpoint(id -> "/v1/conversations/" + id, HttpMethod.GET, (Object[])new Conversation[0]);
        this.updateConversation = new Endpoint(req -> "/v1/conversations/" + req.getId(), HttpMethod.PUT, (Object[])new Conversation[0]);
        this.deleteConversation = new Endpoint(id -> "/v1/conversations/" + id, HttpMethod.DELETE, (Object[])new Void[0]);
        this.listUserConversations = new Endpoint(req -> "/v1/users/" + req.userId + "/conversations", HttpMethod.GET, (Object[])new ListUserConversationsResponse[0]);
        this.listMembers = new Endpoint(req -> "/v1/conversations/" + req.conversationId + "/members/", HttpMethod.GET, (Object[])new ListMembersResponse[0]);
        this.getMember = new Endpoint(req -> "/v1/conversations/" + req.conversationId + "/members/" + req.resourceId, HttpMethod.GET, (Object[])new Member[0]);
        this.createMember = new Endpoint(req -> "/v1/conversations/" + req.getConversationId() + "/members/", HttpMethod.POST, (Object[])new Member[0]);
        this.updateMember = new Endpoint(req -> "/v1/conversations/" + req.conversationId + "/members/" + req.resourceId, HttpMethod.PATCH, (Object[])new Member[0]);
        this.deleteEvent = new Endpoint(req -> "/v1/conversations/" + req.conversationId + "/events/" + req.resourceId, HttpMethod.DELETE, (Object[])new Void[0]);
        this.getEvent = new Endpoint(req -> "/v1/conversations/" + req.conversationId + "/events/" + req.resourceId, HttpMethod.GET, (Object[])new Event[0]);
        this.listEvents = new Endpoint(req -> "/v1/conversations/" + req.conversationId + "/events/", HttpMethod.GET, (Object[])new ListEventsResponse[0]);
        this.createEvent = new Endpoint(req -> "/v1/conversations/" + req.conversationId + "/events/", HttpMethod.POST, (Object[])new Event[0]);
    }

    private static String validateId(String prefix, String arg) {
        int prefixLength = prefix.length();
        int expectedLength = prefixLength + 36;
        if (arg == null || arg.length() != expectedLength) {
            throw new IllegalArgumentException("Invalid ID: '" + arg + "' is not " + expectedLength + " characters in length.");
        }
        if (!arg.startsWith(prefix)) {
            String actualPrefix = arg.substring(0, prefixLength);
            throw new IllegalArgumentException("Invalid ID: expected prefix '" + prefix + "' but got '" + actualPrefix + "'.");
        }
        return prefix + UUID.fromString(arg.substring(prefixLength));
    }

    private static String validateConversationId(String id) {
        return ConversationsClient.validateId("CON-", id);
    }

    static String validateMemberId(String id) {
        return ConversationsClient.validateId("MEM-", id);
    }

    private static String validateUserId(String id) {
        return ConversationsClient.validateId("USR-", id);
    }

    private static String validateEventId(int id) {
        if (id < 0) {
            throw new IllegalArgumentException("Event ID cannot be negative.");
        }
        return String.valueOf(id);
    }

    private static <T> T validateRequest(T request) {
        return Objects.requireNonNull(request, "Request parameter is required.");
    }

    private static <F extends AbstractConversationsFilterRequest, B extends AbstractConversationsFilterRequest.Builder<? extends F, ?>> F defaultFilterParams(B builder) {
        return (F)((AbstractConversationsFilterRequest)builder.pageSize(100).build());
    }

    public List<BaseConversation> listConversations() {
        return this.listConversations((ListConversationsRequest)ConversationsClient.defaultFilterParams(ListConversationsRequest.builder())).getConversations();
    }

    public ListConversationsResponse listConversations(ListConversationsRequest filter) {
        return this.listConversations.execute(ConversationsClient.validateRequest(filter));
    }

    public Conversation createConversation(Conversation request) {
        return this.createConversation.execute(ConversationsClient.validateRequest(request));
    }

    public Conversation getConversation(String conversationId) {
        return this.getConversation.execute(ConversationsClient.validateConversationId(conversationId));
    }

    public Conversation updateConversation(String conversationId, Conversation request) {
        ConversationsClient.validateRequest(request).id = ConversationsClient.validateConversationId(conversationId);
        return this.updateConversation.execute(request);
    }

    public void deleteConversation(String conversationId) {
        this.deleteConversation.execute(ConversationsClient.validateConversationId(conversationId));
    }

    public List<UserConversation> listUserConversations(String userId) {
        return this.listUserConversations(userId, (ListUserConversationsRequest)ConversationsClient.defaultFilterParams(ListUserConversationsRequest.builder())).getConversations();
    }

    public ListUserConversationsResponse listUserConversations(String userId, ListUserConversationsRequest filter) {
        ConversationsClient.validateRequest(filter).userId = ConversationsClient.validateUserId(userId);
        return this.listUserConversations.execute(filter);
    }

    public List<BaseMember> listMembers(String conversationId) {
        return this.listMembers(conversationId, ((ListMembersRequest.Builder)ListMembersRequest.builder().pageSize(100)).build()).getMembers();
    }

    public ListMembersResponse listMembers(String conversationId, ListMembersRequest filter) {
        ConversationsClient.validateRequest(filter).conversationId = ConversationsClient.validateConversationId(conversationId);
        return this.listMembers.execute(filter);
    }

    public Member getMember(String conversationId, String memberId) {
        return this.getMember.execute(new ConversationResourceRequestWrapper(ConversationsClient.validateConversationId(conversationId), ConversationsClient.validateMemberId(memberId)));
    }

    public Member createMember(String conversationId, Member request) {
        ConversationsClient.validateRequest(request).setConversationId(ConversationsClient.validateConversationId(conversationId));
        return this.createMember.execute(request);
    }

    public Member updateMember(UpdateMemberRequest request) {
        ConversationsClient.validateConversationId(ConversationsClient.validateRequest(request).conversationId);
        ConversationsClient.validateMemberId(request.resourceId);
        return this.updateMember.execute(request);
    }

    public List<Event> listEvents(String conversationId) {
        return this.listEvents(conversationId, ((ListEventsRequest.Builder)ListEventsRequest.builder().pageSize(100)).build()).getEvents();
    }

    public ListEventsResponse listEvents(String conversationId, ListEventsRequest request) {
        ConversationsClient.validateRequest(request).conversationId = ConversationsClient.validateConversationId(conversationId);
        return this.listEvents.execute(request);
    }

    public Event getEvent(String conversationId, int eventId) {
        return this.getEvent.execute(new ConversationResourceRequestWrapper(ConversationsClient.validateConversationId(conversationId), ConversationsClient.validateEventId(eventId)));
    }

    public <E extends Event> E createEvent(String conversationId, E request) {
        ConversationsClient.validateRequest(request).conversationId = ConversationsClient.validateConversationId(conversationId);
        return (E)this.createEvent.execute(request);
    }

    public void deleteEvent(String conversationId, int eventId) {
        this.deleteEvent.execute(new ConversationResourceRequestWrapper(ConversationsClient.validateConversationId(conversationId), ConversationsClient.validateEventId(eventId)));
    }
}

