/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.conversations;

import com.vonage.client.conversations.AbstractConversationsFilterRequest;
import com.vonage.client.conversations.AbstractListUserRequest;
import com.vonage.client.conversations.MemberState;
import com.vonage.client.conversations.OrderBy;
import java.time.Instant;
import java.util.Map;

public final class ListUserConversationsRequest
extends AbstractListUserRequest {
    private final MemberState state;
    private final OrderBy orderBy;
    private final Boolean includeCustomData;

    ListUserConversationsRequest(Builder builder) {
        super(builder);
        this.state = builder.state;
        this.orderBy = builder.orderBy;
        this.includeCustomData = builder.includeCustomData;
    }

    @Override
    public Map<String, String> makeParams() {
        Map<String, String> params = super.makeParams();
        if (this.state != null) {
            params.put("state", this.state.toString());
        }
        if (this.orderBy != null) {
            params.put("order_by", this.orderBy.toString());
        }
        if (this.includeCustomData != null) {
            params.put("include_custom_data", this.includeCustomData.toString());
        }
        return params;
    }

    @Override
    public Instant getStartDate() {
        return this.startDate;
    }

    public MemberState getState() {
        return this.state;
    }

    public OrderBy getOrderBy() {
        return this.orderBy;
    }

    public Boolean getIncludeCustomData() {
        return this.includeCustomData;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractConversationsFilterRequest.Builder<ListUserConversationsRequest, Builder> {
        private MemberState state;
        private OrderBy orderBy;
        private Boolean includeCustomData;

        Builder() {
        }

        @Override
        public Builder startDate(Instant startDate) {
            return (Builder)super.startDate(startDate);
        }

        public Builder state(MemberState state) {
            this.state = state;
            return this;
        }

        public Builder orderBy(OrderBy orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        public Builder includeCustomData(Boolean includeCustomData) {
            this.includeCustomData = includeCustomData;
            return this;
        }

        @Override
        public ListUserConversationsRequest build() {
            return new ListUserConversationsRequest(this);
        }
    }
}

