/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.conversations;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.JsonableBaseObject;

public final class Location
extends JsonableBaseObject {
    private Double longitude;
    private Double latitude;
    private String name;
    private String address;

    Location() {
    }

    Location(Builder builder) {
        this.longitude = builder.longitude;
        this.latitude = builder.latitude;
        this.name = builder.name;
        this.address = builder.address;
    }

    @JsonProperty(value="longitude")
    public Double getLongitude() {
        return this.longitude;
    }

    @JsonProperty(value="latitude")
    public Double getLatitude() {
        return this.latitude;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="address")
    public String getAddress() {
        return this.address;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Double longitude;
        private Double latitude;
        private String name;
        private String address;

        private Builder() {
        }

        public Builder longitude(double longitude) {
            this.longitude = longitude;
            return this;
        }

        public Builder latitude(double latitude) {
            this.latitude = latitude;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder address(String address) {
            this.address = address;
            return this;
        }

        public Location build() {
            return new Location(this);
        }
    }
}

