/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.conversations;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.vonage.client.Jsonable;
import com.vonage.client.JsonableBaseObject;
import com.vonage.client.common.ChannelType;
import com.vonage.client.users.channels.Channel;
import java.io.IOException;
import java.util.Objects;

@JsonDeserialize(using=Deserializer.class)
public class MemberChannel
extends JsonableBaseObject {
    ChannelType type;
    Channel from;
    Channel to;

    protected MemberChannel() {
    }

    @JsonProperty(value="type")
    public ChannelType getType() {
        return this.type;
    }

    @JsonProperty(value="from")
    public Channel getFrom() {
        return this.from;
    }

    @JsonProperty(value="to")
    public Channel getTo() {
        return this.to;
    }

    static class Deserializer
    extends StdDeserializer<MemberChannel> {
        private MemberChannel mc;

        protected Deserializer() {
            super(MemberChannel.class);
        }

        public MemberChannel deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return this.deserialize(p, ctxt, new MemberChannel());
        }

        public MemberChannel deserialize(JsonParser p, DeserializationContext ctxt, MemberChannel intoValue) throws IOException {
            this.mc = Objects.requireNonNull(intoValue);
            JsonNode rootNode = (JsonNode)p.readValueAsTree();
            JsonNode typeNode = rootNode.get("type");
            if (typeNode != null) {
                this.mc.type = ChannelType.fromString(typeNode.asText());
            }
            this.mc.from = this.inferConcreteChannel(rootNode.get("from"));
            this.mc.to = this.inferConcreteChannel(rootNode.get("to"));
            return this.mc;
        }

        private Channel inferConcreteChannel(JsonNode node) {
            if (node == null || !node.isObject()) {
                return null;
            }
            JsonNode typeNode = node.get("type");
            ChannelType fromType = typeNode != null ? ChannelType.fromString(typeNode.asText()) : this.mc.type;
            Class<? extends Channel> concreteClass = Channel.getConcreteClass(fromType);
            if (concreteClass == null) {
                throw new IllegalStateException("Unmapped class for type " + (Object)((Object)fromType));
            }
            return Jsonable.fromJson(node.toString(), concreteClass);
        }
    }
}

