/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.insight;

import com.vonage.client.QueryParamsRequest;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class BaseInsightRequest
implements QueryParamsRequest {
    protected final String number;
    protected final String country;
    Boolean cnam;

    protected BaseInsightRequest(String number, String country) {
        this.number = number;
        if (this.number == null || number.length() < 2) {
            throw new IllegalStateException("Must provide a number for insight.");
        }
        this.country = country;
        if (this.country != null && country.length() != 2) {
            throw new IllegalArgumentException("Country code must be 2 letters long.");
        }
    }

    public String getNumber() {
        return this.number;
    }

    public String getCountry() {
        return this.country;
    }

    public Map<String, String> makeParams() {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>(8);
        params.put("number", this.number);
        if (this.country != null) {
            params.put("country", this.country);
        }
        if (this.cnam != null) {
            params.put("cnam", this.cnam.toString());
        }
        return params;
    }
}

