/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.insight;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.JsonableBaseObject;

public class CarrierDetails
extends JsonableBaseObject {
    private String networkCode;
    private String name;
    private String country;
    private NetworkType networkType;

    @JsonProperty(value="network_code")
    public String getNetworkCode() {
        return this.networkCode;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="country")
    public String getCountry() {
        return this.country;
    }

    @JsonProperty(value="network_type")
    public NetworkType getNetworkType() {
        return this.networkType;
    }

    public static enum NetworkType {
        MOBILE,
        LANDLINE,
        LANDLINE_PREMIUM,
        LANDLINE_TOLLFREE,
        VIRTUAL,
        UNKNOWN,
        PAGER;


        @JsonCreator
        public static NetworkType fromString(String name) {
            if (name.equalsIgnoreCase("null")) {
                return null;
            }
            try {
                return NetworkType.valueOf(name.toUpperCase());
            }
            catch (IllegalArgumentException iax) {
                return UNKNOWN;
            }
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

