/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.messages;

import com.vonage.client.ApiRegion;
import com.vonage.client.DynamicEndpoint;
import com.vonage.client.HttpConfig;
import com.vonage.client.HttpWrapper;
import com.vonage.client.RestEndpoint;
import com.vonage.client.auth.ApiKeyHeaderAuthMethod;
import com.vonage.client.auth.JWTAuthMethod;
import com.vonage.client.common.HttpMethod;
import com.vonage.client.messages.MessageRequest;
import com.vonage.client.messages.MessageResponse;
import com.vonage.client.messages.MessageResponseException;
import com.vonage.client.messages.UpdateStatusRequest;
import com.vonage.jwt.Jwt;
import java.util.function.Function;

public class MessagesClient {
    private boolean sandbox = false;
    final RestEndpoint<MessageRequest, MessageResponse> sendMessage;
    final RestEndpoint<MessageRequest, MessageResponse> sendMessageSandbox;
    final RestEndpoint<UpdateStatusRequest, Void> updateMessage;

    public MessagesClient(final HttpWrapper wrapper) {
        String messagesPath = "/v1/messages";
        final class Endpoint<T, R>
        extends DynamicEndpoint<T, R> {
            Endpoint(Function<HttpConfig, String> basePathGetter, R ... type) {
                super(DynamicEndpoint.builder(type).responseExceptionType(MessageResponseException.class).wrapper(var4_4).requestMethod(HttpMethod.POST).authMethod(JWTAuthMethod.class, ApiKeyHeaderAuthMethod.class).pathGetter((de, req) -> (String)basePathGetter.apply(de.getHttpWrapper().getHttpConfig()) + "/v1/messages"));
            }
        }
        this.sendMessage = new Endpoint(HttpConfig::getApiBaseUri, (Object[])new MessageResponse[0]);
        this.sendMessageSandbox = new Endpoint(hc -> "https://messages-sandbox.nexmo.com", (Object[])new MessageResponse[0]);
        this.updateMessage = DynamicEndpoint.builder(Void.class).responseExceptionType(MessageResponseException.class).wrapper(wrapper).requestMethod(HttpMethod.PATCH).authMethod(JWTAuthMethod.class, new Class[0]).pathGetter((de, req) -> de.getHttpWrapper().getHttpConfig().getRegionalBaseUri(req.region) + "/v1/messages" + "/" + req.messageId).build();
    }

    public MessageResponse sendMessage(MessageRequest request) throws MessageResponseException {
        return (this.sandbox ? this.sendMessageSandbox : this.sendMessage).execute(request);
    }

    public MessagesClient useSandboxEndpoint() {
        this.sandbox = true;
        return this;
    }

    public MessagesClient useRegularEndpoint() {
        this.sandbox = false;
        return this;
    }

    public void ackInboundMessage(String messageId, ApiRegion region) throws MessageResponseException {
        this.updateMessage.execute(new UpdateStatusRequest("read", messageId, region));
    }

    public void revokeOutboundMessage(String messageId, ApiRegion region) throws MessageResponseException {
        this.updateMessage.execute(new UpdateStatusRequest("revoked", messageId, region));
    }

    public static boolean verifySignature(String jwt, String secret) {
        return Jwt.verifySignature((String)jwt, (String)secret);
    }
}

