/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.messages.whatsapp;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.common.E164;
import com.vonage.client.messages.Channel;
import com.vonage.client.messages.MessageRequest;
import com.vonage.client.messages.MessageType;
import com.vonage.client.messages.whatsapp.Context;
import java.util.UUID;

public abstract class WhatsappRequest
extends MessageRequest {
    final Context context;

    protected WhatsappRequest(Builder<?, ?> builder, MessageType messageType) {
        super(builder, Channel.WHATSAPP, messageType);
        this.context = builder.messageUuid != null ? new Context(builder.messageUuid) : null;
    }

    @Override
    protected void validateSenderAndRecipient(String from, String to) throws IllegalArgumentException {
        this.from = new E164(from).toString();
        this.to = new E164(to).toString();
    }

    @JsonProperty(value="context")
    public Context getContext() {
        return this.context;
    }

    protected static abstract class Builder<M extends WhatsappRequest, B extends Builder<? extends M, ? extends B>>
    extends MessageRequest.Builder<M, B> {
        UUID messageUuid;

        protected Builder() {
        }

        public B contextMessageId(String messageUuid) {
            this.messageUuid = UUID.fromString(messageUuid);
            return (B)this;
        }
    }
}

