/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.numbers;

import com.vonage.client.QueryParamsRequest;
import com.vonage.client.common.E164;
import java.util.LinkedHashMap;
import java.util.Map;

abstract class BaseNumberRequest
implements QueryParamsRequest {
    private final String country;
    private final String msisdn;

    protected BaseNumberRequest(String country, String msisdn) {
        this.country = BaseNumberRequest.validateCountry(country);
        this.msisdn = new E164(msisdn).toString();
    }

    public String getCountry() {
        return this.country;
    }

    public String getMsisdn() {
        return this.msisdn;
    }

    public Map<String, String> makeParams() {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>(4);
        params.put("country", this.country);
        params.put("msisdn", this.msisdn);
        return params;
    }

    static String validateCountry(String country) {
        if (country == null || country.length() != 2) {
            throw new IllegalArgumentException("Country code is required in ISO 3166-1 alpha-2 format.");
        }
        return country.toUpperCase();
    }
}

