/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.numbers;

import com.vonage.client.numbers.BaseNumbersFilter;
import com.vonage.client.numbers.SearchPattern;
import java.util.Map;
import java.util.UUID;

public class ListNumbersFilter
extends BaseNumbersFilter {
    private final UUID applicationId;
    private final Boolean hasApplication;

    private ListNumbersFilter(Builder builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.hasApplication = builder.hasApplication;
    }

    @Deprecated
    public ListNumbersFilter() {
        this(null, null, null, null);
    }

    @Deprecated
    public ListNumbersFilter(Integer index, Integer size, String pattern, SearchPattern searchPattern) {
        this(ListNumbersFilter.builder(index, size, pattern, searchPattern));
    }

    public UUID getApplicationId() {
        return this.applicationId;
    }

    public Boolean getHasApplication() {
        return this.hasApplication;
    }

    @Override
    public Map<String, String> makeParams() {
        Map<String, String> params = super.makeParams();
        if (this.applicationId != null) {
            params.put("application_id", this.applicationId.toString());
        }
        if (this.hasApplication != null) {
            params.put("has_application", this.hasApplication.toString());
        }
        return params;
    }

    @Deprecated
    private static Builder builder(Integer index, Integer size, String pattern, SearchPattern searchPattern) {
        Builder builder = ListNumbersFilter.builder();
        if (index != null) {
            builder.index(index);
        }
        if (size != null) {
            builder.size(size);
        }
        if (pattern != null && searchPattern != null) {
            builder.pattern(searchPattern, pattern);
        }
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends BaseNumbersFilter.Builder<ListNumbersFilter, Builder> {
        private UUID applicationId;
        private Boolean hasApplication;

        Builder() {
        }

        public Builder applicationId(String applicationId) {
            return this.applicationId(UUID.fromString(applicationId));
        }

        public Builder applicationId(UUID applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public Builder hasApplication(boolean hasApplication) {
            this.hasApplication = hasApplication;
            return this;
        }

        @Override
        public ListNumbersFilter build() {
            return new ListNumbersFilter(this);
        }
    }
}

