/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.proactiveconnect;

import com.vonage.client.QueryParamsRequest;
import com.vonage.client.proactiveconnect.SortOrder;
import com.vonage.client.proactiveconnect.SourceType;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;

public class ListEventsFilter
implements QueryParamsRequest {
    private final SortOrder order;
    private final UUID runId;
    private final UUID runItemId;
    private final UUID invocationId;
    private final UUID actionId;
    private final UUID traceId;
    private final String recipientId;
    private final String sourceContext;
    private final SourceType sourceType;
    private final Instant startDate;
    private final Instant endDate;

    ListEventsFilter(Builder builder) {
        this.order = builder.order;
        this.runId = builder.runId != null ? UUID.fromString(builder.runId) : null;
        this.runItemId = builder.runItemId != null ? UUID.fromString(builder.runItemId) : null;
        this.invocationId = builder.invocationId != null ? UUID.fromString(builder.invocationId) : null;
        this.actionId = builder.actionId != null ? UUID.fromString(builder.actionId) : null;
        this.traceId = builder.traceId != null ? UUID.fromString(builder.traceId) : null;
        this.recipientId = builder.recipientId;
        this.sourceContext = builder.sourceContext;
        this.sourceType = builder.sourceType;
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
        if (this.endDate != null && this.startDate != null && this.startDate.isAfter(this.endDate)) {
            throw new IllegalStateException("Start date cannot be later than end date.");
        }
    }

    public Map<String, String> makeParams() {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("page", "1");
        params.put("page_size", "1000");
        if (this.order != null) {
            params.put("order", this.order.toString());
        }
        if (this.runId != null) {
            params.put("run_id", this.runId.toString());
        }
        if (this.runItemId != null) {
            params.put("run_item_id", this.runItemId.toString());
        }
        if (this.invocationId != null) {
            params.put("invocation_id", this.invocationId.toString());
        }
        if (this.actionId != null) {
            params.put("action_id", this.actionId.toString());
        }
        if (this.traceId != null) {
            params.put("trace_id", this.traceId.toString());
        }
        if (this.recipientId != null) {
            params.put("recipient_id", this.recipientId);
        }
        if (this.sourceContext != null) {
            params.put("src_ctx", this.sourceContext);
        }
        if (this.sourceType != null) {
            params.put("src_type", this.sourceType.toString());
        }
        if (this.startDate != null) {
            params.put("date_start", this.startDate.truncatedTo(ChronoUnit.SECONDS).toString());
        }
        if (this.endDate != null) {
            params.put("date_end", this.endDate.truncatedTo(ChronoUnit.SECONDS).toString());
        }
        return params;
    }

    public SortOrder getOrder() {
        return this.order;
    }

    public UUID getRunId() {
        return this.runId;
    }

    public UUID getRunItemId() {
        return this.runItemId;
    }

    public UUID getInvocationId() {
        return this.invocationId;
    }

    public UUID getActionId() {
        return this.actionId;
    }

    public UUID getTraceId() {
        return this.traceId;
    }

    public String getRecipientId() {
        return this.recipientId;
    }

    public String getSourceContext() {
        return this.sourceContext;
    }

    public SourceType getSourceType() {
        return this.sourceType;
    }

    public Instant getStartDate() {
        return this.startDate;
    }

    public Instant getEndDate() {
        return this.endDate;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private SortOrder order;
        private String runId;
        private String runItemId;
        private String invocationId;
        private String actionId;
        private String traceId;
        private String recipientId;
        private String sourceContext;
        private SourceType sourceType;
        private Instant startDate;
        private Instant endDate;

        Builder() {
        }

        public Builder order(SortOrder order) {
            this.order = order;
            return this;
        }

        public Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public Builder runItemId(String runItemId) {
            this.runItemId = runItemId;
            return this;
        }

        public Builder invocationId(String invocationId) {
            this.invocationId = invocationId;
            return this;
        }

        public Builder actionId(String actionId) {
            this.actionId = actionId;
            return this;
        }

        public Builder traceId(String traceId) {
            this.traceId = traceId;
            return this;
        }

        public Builder recipientId(String recipientId) {
            this.recipientId = recipientId;
            return this;
        }

        public Builder sourceContext(String sourceContext) {
            this.sourceContext = sourceContext;
            return this;
        }

        public Builder sourceType(SourceType sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public Builder endDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        public ListEventsFilter build() {
            return new ListEventsFilter(this);
        }
    }
}

