/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.sms.messages;

import com.fasterxml.jackson.annotation.JsonValue;
import com.vonage.client.QueryParamsRequest;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class Message
implements QueryParamsRequest {
    private final MessageType type;
    private final String from;
    private final String to;
    private boolean statusReportRequired;
    private MessageClass messageClass;
    private Long timeToLive;
    private String clientReference;
    private String callbackUrl;
    private String entityId;
    private String contentId;

    protected Message(MessageType type, String from, String to) {
        this(type, from, to, false);
    }

    protected Message(MessageType type, String from, String to, boolean statusReportRequired) {
        this.type = type;
        this.from = from;
        this.to = to;
        this.statusReportRequired = statusReportRequired;
    }

    public MessageType getType() {
        return this.type;
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public String getClientReference() {
        return this.clientReference;
    }

    public void setClientReference(String clientReference) {
        if (clientReference.length() > 40) {
            throw new IllegalArgumentException("Client reference must be 40 characters or less.");
        }
        this.clientReference = clientReference;
    }

    public MessageClass getMessageClass() {
        return this.messageClass;
    }

    public void setMessageClass(MessageClass messageClass) {
        this.messageClass = messageClass;
    }

    public Long getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(Long timeToLive) {
        this.timeToLive = timeToLive;
    }

    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public String getContentId() {
        return this.contentId;
    }

    public void setContentId(String contentId) {
        this.contentId = contentId;
    }

    public boolean getStatusReportRequired() {
        return this.statusReportRequired;
    }

    public void setStatusReportRequired(boolean statusReportRequired) {
        this.statusReportRequired = statusReportRequired;
    }

    public Map<String, String> makeParams() {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("from", this.getFrom());
        params.put("to", this.getTo());
        params.put("type", this.getType().toString());
        if (this.getStatusReportRequired()) {
            params.put("status-report-req", "1");
        }
        if (this.clientReference != null) {
            params.put("client-ref", this.getClientReference());
        }
        if (this.timeToLive != null) {
            params.put("ttl", this.getTimeToLive().toString());
        }
        if (this.callbackUrl != null) {
            params.put("callback", this.getCallbackUrl());
        }
        if (this.messageClass != null) {
            params.put("message-class", Integer.toString(this.getMessageClass().getMessageClass()));
        }
        if (this.entityId != null) {
            params.put("entity-id", this.getEntityId());
        }
        if (this.contentId != null) {
            params.put("content-id", this.getContentId());
        }
        return params;
    }

    public static enum MessageType {
        TEXT,
        BINARY,
        UNICODE;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }

    public static enum MessageClass {
        CLASS_0(0),
        CLASS_1(1),
        CLASS_2(2),
        CLASS_3(3);

        private final int messageClass;

        private MessageClass(int messageClass) {
            this.messageClass = messageClass;
        }

        @JsonValue
        public int getMessageClass() {
            return this.messageClass;
        }
    }
}

