/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.subaccounts;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.JsonableBaseObject;
import java.util.Objects;

class AbstractTransfer
extends JsonableBaseObject {
    private String from;
    private String to;
    private String primaryAccountId;

    protected AbstractTransfer() {
    }

    protected AbstractTransfer(Builder<?, ?> builder) {
        this.from = AbstractTransfer.validateAccountKey(((Builder)builder).from, "From account");
        this.to = AbstractTransfer.validateAccountKey(((Builder)builder).to, "To account");
    }

    static String validateAccountKey(String key, String name) {
        String message = name + " API key is required.";
        if (Objects.requireNonNull(key, message).trim().isEmpty() || key.length() != 8) {
            throw new IllegalArgumentException("Invalid '" + name + "' API key.");
        }
        return key;
    }

    @JsonProperty(value="masterAccountId")
    public String getPrimaryAccountId() {
        return this.primaryAccountId;
    }

    @JsonProperty(value="from")
    public String getFrom() {
        return this.from;
    }

    @JsonProperty(value="to")
    public String getTo() {
        return this.to;
    }

    protected static abstract class Builder<T extends AbstractTransfer, B extends Builder<? extends T, ? extends B>> {
        private String from;
        private String to;

        Builder() {
        }

        public B from(String from) {
            this.from = from;
            return (B)this;
        }

        public B to(String to) {
            this.to = to;
            return (B)this;
        }

        public abstract T build();
    }
}

