/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.verify2;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.Jsonable;
import com.vonage.client.JsonableBaseObject;
import com.vonage.client.verify2.CallbackType;
import com.vonage.client.verify2.Channel;
import com.vonage.client.verify2.VerificationStatus;
import com.vonage.client.verify2.WorkflowStatus;
import java.net.URI;
import java.time.Instant;
import java.util.List;
import java.util.UUID;

public class VerificationCallback
extends JsonableBaseObject {
    protected Channel channel;
    protected UUID requestId;
    protected Instant triggeredAt;
    protected Instant finalizedAt;
    protected Instant submittedAt;
    protected VerificationStatus status;
    protected CallbackType type;
    protected String clientRef;
    protected Integer channelTimeout;
    protected List<WorkflowStatus> workflows;
    @JsonProperty(value="action")
    Action action;

    protected VerificationCallback() {
    }

    @JsonProperty(value="channel")
    public Channel getChannel() {
        return this.channel;
    }

    @JsonProperty(value="request_id")
    public UUID getRequestId() {
        return this.requestId;
    }

    @JsonProperty(value="triggered_at")
    public Instant getTriggeredAt() {
        return this.triggeredAt;
    }

    @JsonProperty(value="finalized_at")
    public Instant getFinalizedAt() {
        return this.finalizedAt;
    }

    @JsonProperty(value="submitted_at")
    public Instant getSubmittedAt() {
        return this.submittedAt;
    }

    @JsonProperty(value="status")
    public VerificationStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="type")
    public CallbackType getType() {
        return this.type;
    }

    @JsonProperty(value="client_ref")
    public String getClientRef() {
        return this.clientRef;
    }

    @JsonProperty(value="channel_timeout")
    public Integer getChannelTimeout() {
        return this.channelTimeout;
    }

    @JsonProperty(value="workflow")
    public List<WorkflowStatus> getWorkflows() {
        return this.workflows;
    }

    @JsonIgnore
    public URI getSilentAuthUrl() {
        if (this.action == null || this.channel != Channel.SILENT_AUTH) {
            return null;
        }
        return this.action.checkUrl;
    }

    @JsonCreator
    public static VerificationCallback fromJson(String json) {
        return (VerificationCallback)Jsonable.fromJson((String)json, (Jsonable[])new VerificationCallback[0]);
    }

    static class Action
    extends JsonableBaseObject {
        @JsonProperty(value="type")
        String type;
        @JsonProperty(value="check_url")
        URI checkUrl;

        Action() {
        }
    }
}

