/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.video;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.Jsonable;
import com.vonage.client.JsonableBaseObject;
import com.vonage.client.video.BroadcastStatus;
import com.vonage.client.video.BroadcastUrls;
import com.vonage.client.video.Hls;
import com.vonage.client.video.Resolution;
import com.vonage.client.video.Rtmp;
import com.vonage.client.video.StreamComposition;
import com.vonage.client.video.StreamCompositionLayout;
import com.vonage.client.video.StreamMode;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class Broadcast
extends StreamComposition {
    private String multiBroadcastTag;
    @JsonProperty(value="updatedAt")
    private Long updatedAt;
    @JsonProperty(value="maxDuration")
    private Integer maxDuration;
    private BroadcastStatus status;
    private BroadcastUrls broadcastUrls;
    private Settings settings;
    private Outputs outputs;

    protected Broadcast() {
    }

    protected Broadcast(Builder builder) {
        super(builder);
        this.outputs = new Outputs();
        this.outputs.rtmp = builder.rtmps.isEmpty() ? null : builder.rtmps;
        if ((this.outputs.hls = builder.hls) == null && this.outputs.rtmp == null) {
            throw new IllegalStateException("At least one output stream (RTMP or HLS) must be specified.");
        }
        this.maxDuration = builder.maxDuration;
        if (this.maxDuration != null && (this.maxDuration < 60 || this.maxDuration > 36000)) {
            throw new IllegalArgumentException("maxDuration must be between 60 seconds and 10 hours.");
        }
        this.multiBroadcastTag = builder.multiBroadcastTag;
    }

    @JsonProperty(value="outputs")
    Outputs getOutputs() {
        return this.outputs;
    }

    @JsonProperty(value="settings")
    Settings getSettings() {
        return this.settings;
    }

    @JsonProperty(value="multiBroadcastTag")
    public String getMultiBroadcastTag() {
        return this.multiBroadcastTag;
    }

    @JsonProperty(value="updatedAt")
    public Long getUpdatedAtMillis() {
        return this.updatedAt;
    }

    @JsonIgnore
    public Instant getUpdatedAt() {
        return this.updatedAt != null ? Instant.ofEpochMilli(this.updatedAt) : null;
    }

    @JsonProperty(value="maxDuration")
    public Integer getMaxDurationSeconds() {
        return this.maxDuration;
    }

    @JsonIgnore
    public Duration getMaxDuration() {
        return this.maxDuration != null ? Duration.ofSeconds(this.maxDuration.intValue()) : null;
    }

    @JsonProperty(value="status")
    public BroadcastStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="broadcastUrls")
    public BroadcastUrls getBroadcastUrls() {
        return this.broadcastUrls;
    }

    @JsonIgnore
    public Hls getHlsSettings() {
        return this.settings != null ? this.settings.hls : null;
    }

    public static Broadcast fromJson(String json) {
        return (Broadcast)Jsonable.fromJson((String)json, (Jsonable[])new Broadcast[0]);
    }

    public static Builder builder(String sessionId) {
        return new Builder(sessionId);
    }

    static class Outputs
    extends JsonableBaseObject {
        @JsonProperty(value="rtmp")
        private List<Rtmp> rtmp;
        @JsonProperty(value="hls")
        private Hls hls;

        Outputs() {
        }
    }

    public static class Builder
    extends StreamComposition.Builder {
        private final List<Rtmp> rtmps = new ArrayList<Rtmp>();
        private Hls hls;
        private Integer maxDuration;
        private String multiBroadcastTag;

        Builder(String sessionId) {
            this.sessionId = sessionId;
        }

        public Builder streamMode(StreamMode streamMode) {
            this.streamMode = streamMode;
            return this;
        }

        public Builder resolution(Resolution resolution) {
            this.resolution = resolution;
            return this;
        }

        public Builder layout(StreamCompositionLayout layout) {
            this.layout = layout;
            return this;
        }

        public Builder addRtmpStream(Rtmp rtmp) {
            this.rtmps.add(Objects.requireNonNull(rtmp, "Rtmp cannot be null."));
            return this;
        }

        public Builder rtmpStreams(Collection<Rtmp> rtmps) {
            for (Rtmp rtmp : Objects.requireNonNull(rtmps, "Rtmps cannot be null.")) {
                this.addRtmpStream(rtmp);
            }
            return this;
        }

        public Builder hls(Hls hls) {
            this.hls = hls;
            return this;
        }

        public Builder maxBitrate(int maxBitrate) {
            this.maxBitrate = maxBitrate;
            return this;
        }

        public Builder maxDuration(int maxDuration) {
            this.maxDuration = maxDuration;
            return this;
        }

        public Builder maxDuration(Duration maxDuration) {
            return this.maxDuration((int)maxDuration.getSeconds());
        }

        public Builder multiBroadcastTag(String multiBroadcastTag) {
            this.multiBroadcastTag = multiBroadcastTag;
            return this;
        }

        public Broadcast build() {
            return new Broadcast(this);
        }
    }

    static class Settings
    extends JsonableBaseObject {
        @JsonProperty(value="hls")
        private Hls hls;

        Settings() {
        }
    }
}

