/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.video;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.JsonableBaseObject;
import com.vonage.client.video.AbstractSessionTokenRequest;
import com.vonage.client.video.Resolution;
import java.net.URI;
import java.util.Objects;

public final class RenderRequest
extends AbstractSessionTokenRequest {
    private URI url;
    private Integer maxDuration;
    private Resolution resolution;
    private Properties properties;

    private RenderRequest() {
    }

    private RenderRequest(Builder builder) {
        super(builder);
        int urlLength = Objects.requireNonNull(builder.url, "URL is required.").length();
        if (urlLength < 15 || urlLength > 2048) {
            throw new IllegalArgumentException("URL must be between 15 and 2048 characters long.");
        }
        this.url = URI.create(builder.url);
        this.properties = new Properties(builder.name);
        this.maxDuration = builder.maxDuration;
        if (this.maxDuration != null && (this.maxDuration < 60 || this.maxDuration > 36000)) {
            throw new IllegalArgumentException("Max duration must be between 60 and 36000 seconds.");
        }
        this.resolution = builder.resolution;
    }

    @JsonProperty(value="url")
    public URI getUrl() {
        return this.url;
    }

    @JsonProperty(value="maxDuration")
    public Integer getMaxDuration() {
        return this.maxDuration;
    }

    @JsonProperty(value="resolution")
    public Resolution getResolution() {
        return this.resolution;
    }

    @JsonProperty(value="properties")
    public Properties getProperties() {
        return this.properties;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractSessionTokenRequest.Builder<RenderRequest, Builder> {
        private String name;
        private String url;
        private Integer maxDuration;
        private Resolution resolution;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder maxDuration(int maxDuration) {
            this.maxDuration = maxDuration;
            return this;
        }

        public Builder resolution(Resolution resolution) {
            this.resolution = resolution;
            return this;
        }

        @Override
        public RenderRequest build() {
            return new RenderRequest(this);
        }
    }

    public static final class Properties
    extends JsonableBaseObject {
        private String name;

        private Properties() {
        }

        private Properties(String name) {
            this.name = name;
            if (this.name == null || name.trim().isEmpty()) {
                throw new IllegalArgumentException("Name is required.");
            }
            if (name.length() > 200) {
                throw new IllegalArgumentException("Name cannot exceed 200 characters.");
            }
        }

        @JsonProperty(value="name")
        public String getName() {
            return this.name;
        }
    }
}

