/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.video;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.JsonableBaseObject;
import com.vonage.client.video.AbstractSessionTokenRequest;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class SipDialRequest
extends AbstractSessionTokenRequest {
    @JsonProperty(value="sip")
    private Sip sip;

    SipDialRequest() {
    }

    private SipDialRequest(Builder builder) {
        super(builder);
        this.sip = new Sip();
        this.sip.uri = Objects.requireNonNull(builder.uri, "SIP URI is required.");
        this.sip.from = builder.from;
        this.sip.secure = builder.secure;
        this.sip.video = builder.video;
        this.sip.observeForceMute = builder.observeForceMute;
        if (!builder.headers.isEmpty()) {
            this.sip.headers = builder.headers;
        }
        if (builder.username != null) {
            this.sip.auth = new Sip.Auth();
            this.sip.auth.username = builder.username;
            if (builder.password != null) {
                this.sip.auth.password = builder.password;
            }
        } else if (builder.password != null) {
            throw new IllegalStateException("SIP Auth username is required if password is provided.");
        }
    }

    @JsonIgnore
    public String getUri() {
        return this.sip.uri;
    }

    @JsonIgnore
    public String getFrom() {
        return this.sip.from;
    }

    @JsonIgnore
    public Map<String, String> getHeaders() {
        return this.sip.headers;
    }

    @JsonIgnore
    public String getUsername() {
        return this.sip.auth != null ? this.sip.auth.username : null;
    }

    @JsonIgnore
    public String getPassword() {
        return this.sip.auth != null ? this.sip.auth.password : null;
    }

    @JsonIgnore
    public Boolean getSecure() {
        return this.sip.secure;
    }

    @JsonIgnore
    public Boolean getVideo() {
        return this.sip.video;
    }

    @JsonIgnore
    public Boolean getObserveForceMute() {
        return this.sip.observeForceMute;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractSessionTokenRequest.Builder<SipDialRequest, Builder> {
        private final Map<String, String> headers = new HashMap<String, String>();
        private String from;
        private String uri;
        private String username;
        private String password;
        private Boolean secure;
        private Boolean video;
        private Boolean observeForceMute;

        public Builder uri(URI uri, boolean secure) {
            this.uri = uri + (secure ? ";transport=tls" : "");
            return this;
        }

        public Builder from(String from) {
            this.from = from;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder addHeader(String key, String value) {
            this.headers.put(key, value);
            return this;
        }

        public Builder addHeaders(Map<String, String> headers) {
            this.headers.putAll(headers);
            return this;
        }

        public Builder secure(boolean secure) {
            this.secure = secure;
            return this;
        }

        public Builder video(boolean video) {
            this.video = video;
            return this;
        }

        public Builder observeForceMute(boolean observeForceMute) {
            this.observeForceMute = observeForceMute;
            return this;
        }

        @Override
        public SipDialRequest build() {
            return new SipDialRequest(this);
        }
    }

    static class Sip
    extends JsonableBaseObject {
        @JsonProperty(value="uri")
        String uri;
        @JsonProperty(value="from")
        String from;
        @JsonProperty(value="headers")
        Map<String, String> headers;
        @JsonProperty(value="auth")
        Auth auth;
        @JsonProperty(value="secure")
        Boolean secure;
        @JsonProperty(value="video")
        Boolean video;
        @JsonProperty(value="observeForceMute")
        Boolean observeForceMute;

        Sip() {
        }

        static class Auth
        extends JsonableBaseObject {
            @JsonProperty(value="username")
            String username;
            @JsonProperty(value="password")
            String password;

            Auth() {
            }
        }
    }
}

