/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.video;

import com.vonage.client.video.Role;
import com.vonage.jwt.Jwt;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;

public class TokenOptions {
    private final Role role;
    private final Duration ttl;
    private final String data;
    private final List<String> initialLayoutClassList;

    private TokenOptions(Builder builder) {
        this.role = Objects.requireNonNull(builder.role, "Role cannot be null.");
        this.ttl = Objects.requireNonNull(builder.ttl, "Time-to-Live cannot be null.");
        if (this.ttl.toMillis() > Duration.ofDays(30L).toMillis()) {
            throw new IllegalArgumentException("Time-to-Live cannot exceed 30 days.");
        }
        this.data = builder.data;
        if (this.data != null && this.data.length() > 1000) {
            throw new IllegalArgumentException("Connection data cannot exceed 1000 characters.");
        }
        this.initialLayoutClassList = builder.initialLayoutClassList;
    }

    protected void addClaims(Jwt.Builder jwt) {
        jwt.expiresAt(ZonedDateTime.now().plus(this.ttl));
        jwt.addClaim("role", (Object)this.role.toString());
        if (this.data != null) {
            jwt.addClaim("connection_data", (Object)this.data);
        }
        if (this.initialLayoutClassList != null) {
            jwt.addClaim("initial_layout_class_list", (Object)String.join((CharSequence)" ", this.initialLayoutClassList));
        }
    }

    public Role getRole() {
        return this.role;
    }

    public Duration getExpiryLength() {
        return this.ttl;
    }

    public String getData() {
        return this.data;
    }

    public List<String> getInitialLayoutClassList() {
        return this.initialLayoutClassList;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Role role = Role.PUBLISHER;
        private Duration ttl = Duration.ofHours(24L);
        private String data;
        private List<String> initialLayoutClassList;

        Builder() {
        }

        public Builder role(Role role) {
            this.role = role;
            return this;
        }

        public Builder expiryLength(Duration ttl) {
            this.ttl = ttl;
            return this;
        }

        public Builder data(String data) throws IllegalArgumentException {
            this.data = data;
            return this;
        }

        public Builder initialLayoutClassList(List<String> initialLayoutClassList) {
            this.initialLayoutClassList = initialLayoutClassList;
            return this;
        }

        public TokenOptions build() {
            return new TokenOptions(this);
        }
    }
}

