/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.voice.ncco;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.JsonableBaseObject;
import com.vonage.client.voice.AdvancedMachineDetection;
import com.vonage.client.voice.MachineDetection;
import com.vonage.client.voice.ncco.Action;
import com.vonage.client.voice.ncco.Endpoint;
import com.vonage.client.voice.ncco.EventMethod;
import com.vonage.client.voice.ncco.EventType;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;

public class ConnectAction
extends JsonableBaseObject
implements Action {
    private static final String ACTION = "connect";
    private Collection<Endpoint> endpoint;
    private String from;
    private EventType eventType;
    private Integer limit;
    private Integer timeOut;
    private MachineDetection machineDetection;
    private AdvancedMachineDetection advancedMachineDetection;
    private Collection<String> eventUrl;
    private EventMethod eventMethod;
    private Boolean randomFromNumber;
    private URI ringbackTone;

    ConnectAction() {
    }

    private ConnectAction(Builder builder) {
        this.endpoint = builder.endpoint;
        if (this.endpoint == null || this.endpoint.isEmpty()) {
            throw new IllegalStateException("An endpoint must be specified.");
        }
        this.limit = builder.limit;
        if (this.limit != null && (this.limit < 1 || this.limit > 7200)) {
            throw new IllegalArgumentException("'limit' must be positive and less than 7200 seconds.");
        }
        this.timeOut = builder.timeOut;
        if (this.timeOut != null && (this.timeOut < 3 || this.timeOut > 7200)) {
            throw new IllegalArgumentException("'timeOut' must be between 3 and 7200 seconds.");
        }
        this.from = builder.from;
        this.randomFromNumber = builder.randomFromNumber;
        if (this.randomFromNumber != null && this.from != null) {
            throw new IllegalStateException("'randomFromNumber' and 'from' cannot be used together.");
        }
        this.eventType = builder.eventType;
        this.machineDetection = builder.machineDetection;
        this.advancedMachineDetection = builder.advancedMachineDetection;
        this.eventUrl = builder.eventUrl;
        this.eventMethod = builder.eventMethod;
        this.ringbackTone = builder.ringbackTone;
    }

    @Override
    @JsonProperty(value="action")
    public String getAction() {
        return ACTION;
    }

    @JsonProperty(value="endpoint")
    public Collection<Endpoint> getEndpoint() {
        return this.endpoint;
    }

    @JsonProperty(value="from")
    public String getFrom() {
        return this.from;
    }

    @JsonProperty(value="eventType")
    public EventType getEventType() {
        return this.eventType;
    }

    @JsonProperty(value="timeout")
    public Integer getTimeOut() {
        return this.timeOut;
    }

    @JsonProperty(value="limit")
    public Integer getLimit() {
        return this.limit;
    }

    @JsonProperty(value="machineDetection")
    public MachineDetection getMachineDetection() {
        return this.machineDetection;
    }

    @JsonProperty(value="advancedMachineDetection")
    public AdvancedMachineDetection getAdvancedMachineDetection() {
        return this.advancedMachineDetection;
    }

    @JsonProperty(value="eventUrl")
    public Collection<String> getEventUrl() {
        return this.eventUrl;
    }

    @JsonProperty(value="eventMethod")
    public EventMethod getEventMethod() {
        return this.eventMethod;
    }

    @JsonProperty(value="randomFromNumber")
    public Boolean getRandomFromNumber() {
        return this.randomFromNumber;
    }

    @JsonProperty(value="ringbackTone")
    public URI getRingbackTone() {
        return this.ringbackTone;
    }

    public static Builder builder(Collection<Endpoint> endpoint) {
        return new Builder(endpoint);
    }

    public static Builder builder(Endpoint ... endpoint) {
        return ConnectAction.builder(Arrays.asList(endpoint));
    }

    public static class Builder {
        private Collection<Endpoint> endpoint;
        private String from;
        private EventType eventType;
        private Integer timeOut;
        private Integer limit;
        private MachineDetection machineDetection;
        private AdvancedMachineDetection advancedMachineDetection;
        private Collection<String> eventUrl;
        private EventMethod eventMethod;
        private Boolean randomFromNumber;
        private URI ringbackTone;

        Builder(Collection<Endpoint> endpoint) {
            this.endpoint = endpoint;
        }

        @Deprecated
        public Builder endpoint(Collection<Endpoint> endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder endpoint(Endpoint ... endpoint) {
            return this.endpoint(Arrays.asList(endpoint));
        }

        public Builder from(String from) {
            this.from = from;
            return this;
        }

        public Builder eventType(EventType eventType) {
            this.eventType = eventType;
            return this;
        }

        public Builder timeOut(Integer timeOut) {
            this.timeOut = timeOut;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder machineDetection(MachineDetection machineDetection) {
            this.machineDetection = machineDetection;
            return this;
        }

        public Builder advancedMachineDetection(AdvancedMachineDetection advancedMachineDetection) {
            this.advancedMachineDetection = advancedMachineDetection;
            return this;
        }

        public Builder eventUrl(Collection<String> eventUrl) {
            this.eventUrl = eventUrl;
            return this;
        }

        public Builder eventUrl(String ... eventUrl) {
            return this.eventUrl(Arrays.asList(eventUrl));
        }

        public Builder eventMethod(EventMethod eventMethod) {
            this.eventMethod = eventMethod;
            return this;
        }

        public Builder randomFromNumber(boolean randomFromNumber) {
            this.randomFromNumber = randomFromNumber;
            return this;
        }

        public Builder ringbackTone(String ringbackTone) {
            this.ringbackTone = URI.create(ringbackTone);
            return this;
        }

        public ConnectAction build() {
            return new ConnectAction(this);
        }
    }
}

