/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.voice.ncco;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.JsonableBaseObject;
import com.vonage.client.voice.EndpointType;
import com.vonage.client.voice.ncco.Endpoint;

public class PhoneEndpoint
extends JsonableBaseObject
implements Endpoint {
    private final String number;
    private final String dtmfAnswer;
    private final OnAnswer onAnswer;

    private PhoneEndpoint(Builder builder) {
        this.number = builder.number;
        this.dtmfAnswer = builder.dtmfAnswer;
        this.onAnswer = builder.onAnswerUrl != null ? new OnAnswer(builder.onAnswerUrl, builder.onAnswerRingback) : null;
    }

    @Override
    public String getType() {
        return EndpointType.PHONE.toString();
    }

    @JsonProperty(value="number")
    public String getNumber() {
        return this.number;
    }

    @JsonProperty(value="dtmfAnswer")
    public String getDtmfAnswer() {
        return this.dtmfAnswer;
    }

    @JsonProperty(value="onAnswer")
    public OnAnswer getOnAnswer() {
        return this.onAnswer;
    }

    public static Builder builder(String number) {
        return new Builder(number);
    }

    public static class Builder {
        private String number;
        private String dtmfAnswer;
        private String onAnswerUrl;
        private String onAnswerRingback;

        Builder(String number) {
            this.number = number;
        }

        public Builder number(String number) {
            this.number = number;
            return this;
        }

        public Builder dtmfAnswer(String dtmfAnswer) {
            this.dtmfAnswer = dtmfAnswer;
            return this;
        }

        public Builder onAnswer(String url) {
            this.onAnswerUrl = url;
            return this;
        }

        public Builder onAnswer(String url, String ringback) {
            this.onAnswerUrl = url;
            this.onAnswerRingback = ringback;
            return this;
        }

        public PhoneEndpoint build() {
            return new PhoneEndpoint(this);
        }
    }

    public static class OnAnswer {
        private final String url;
        private final String ringback;

        private OnAnswer(String url, String ringback) {
            this.url = url;
            this.ringback = ringback;
        }

        @JsonProperty(value="url")
        public String getUrl() {
            return this.url;
        }

        @JsonProperty(value="ringback")
        public String getRingback() {
            return this.ringback;
        }
    }
}

